/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.huifu.dc.service;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class Request {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Request.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String post(String msg, String uri) {
        String url = RequestContextUtils.getBankParameterValue((String)"ip") + uri;
        logger.info("Request {} {}", new Object[]{url, msg});
        int timeOut = Integer.parseInt(RequestContextUtils.getBankParameterValue((String)"timeout")) * 60 * 1000;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPost.setEntity((HttpEntity)new StringEntity(msg, StandardCharsets.UTF_8));
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(timeOut).build();
        try (CloseableHttpResponse httpResponse = Request.execute(url, config, httpPost);){
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                logger.info("Response {}", (Object)response);
                String string = response;
                return string;
            }
            logger.error("\u94f6\u884c\u8fd4\u56de\u5f02\u5e38 - URI: {}, \u72b6\u6001\u7801: {}", new Object[]{url, statusCode});
            HttpEntity errorEntity = httpResponse.getEntity();
            String errorBody = errorEntity != null ? EntityUtils.toString((HttpEntity)errorEntity) : "No error details";
            if (statusCode != 922) throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)(statusCode + ""), (String)("HTTP Error " + statusCode + ": " + errorBody)));
            errorBody = ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5546\u6237\u79c1\u94a5\u662f\u5426\u7ef4\u62a4\u6b63\u786e\u3002", (String)"", (String)"ebg-aqap-banks-huifu-dc", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)(statusCode + ""), (String)("HTTP Error " + statusCode + ": " + errorBody)));
        }
        catch (IOException e) {
            String errorMsg = e.getMessage() != null ? e.getMessage() : "";
            logger.error(String.format("Bank API\u901a\u4fe1\u5f02\u5e38 - URI: %s, \u9519\u8bef: %s", url, e.toString()), (Throwable)e);
            if (!errorMsg.contains("connect timed out")) throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u670d\u52a1\u901a\u4fe1\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u83b7\u53d6\u8be6\u60c5\u3002", (String)"", (String)"ebg-aqap-banks-huifu-dc", (Object[])new Object[0]));
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fde\u63a5\u94f6\u884c\u670d\u52a1\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u3002", (String)"", (String)"ebg-aqap-banks-huifu-dc", (Object[])new Object[0]));
        }
    }

    public static CloseableHttpResponse execute(String url, RequestConfig config, HttpPost httpPost) throws IOException {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        if (url.toLowerCase().startsWith("https")) {
            TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
            try {
                SSLContext sslcontext = SSLContextBuilder.create().loadTrustMaterial(null, acceptingTrustStrategy).build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                logger.error("Build SSL Error \uff1a" + e.getMessage(), (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)"SSL Error");
            }
        }
        CloseableHttpClient client = clientBuilder.setDefaultRequestConfig(config).build();
        return client.execute((HttpUriRequest)httpPost);
    }
}

