/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc;

import com.google.common.collect.Lists;
import java.util.List;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.common.framework.properties.LinkPayConfig;
import kd.ebg.aqap.common.framework.properties.PropertyChecker;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public class BankBusinessConfig
extends BankPropertyConfig {
    private static final PropertyConfigItem CEB_DC_has_5s_interval = PropertyConfigItem.builder().key("CEB_DC_has_5s_interval").mlName(new MultiLangEnumBridge("\u63a5\u53e3\u8c03\u7528\u662f\u5426\u67095s\u95f4\u9694", "BankBusinessConfig_60", "ebg-aqap-banks-ceb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u63a5\u53e3\u8c03\u7528\u662f\u5426\u67095s\u95f4\u9694:", "BankBusinessConfig_64", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("1)\u662f \uff1a\u4ed8\u6b3e\u63a5\u53e3\u8bf7\u6c42\u9650\u5236\uff0c\u591a\u6b21\u8bf7\u6c42\u4e4b\u95f4\u6bcf\u6b21\u8bf7\u6c42\u95f4\u9694\u4e94\u79d2\u3002", "BankBusinessConfig_61", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("2)\u5426 \uff1a\u9ed8\u8ba4\u65b9\u5f0f\u3002", "BankBusinessConfig_62", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("\u8be5\u53c2\u6570\u9002\u7528\u4e8e\uff1ab2e005005\u6279\u91cf\u4ee3\u53d1\u3001b2e004001\u5bf9\u516c\u652f\u4ed8\u3001b2e004001\u5bf9\u79c1\u652f\u4ed8\u3001b2e006021\u5212\u62e8\u652f\u4ed8\u3001b2e005026\u4e13\u5c5e\u4ee3\u53d1", "BankBusinessConfig_63", "ebg-aqap-banks-ceb-dc")})).mlSourceNames(mlTrueFalseCN).sourceValues(trueFalseEN).defaultValues(defaultFalse).checkers((List)Lists.newArrayList((Object[])new PropertyChecker[]{notNull})).mustInput(true).build();
    private static final PropertyConfigItem BANK_ACC_TYPE = PropertyConfigItem.builder().key("bank_accType").mlName(new MultiLangEnumBridge("\u8d26\u6237\u7c7b\u522b", "BankBusinessConfig_0", "ebg-aqap-banks-ceb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u8d26\u6237\u7c7b\u522b\uff1a\u8d26\u6237\u5207\u6362\u540e\u5bf9\u4e1a\u52a1\u7684\u5904\u7406\u5dee\u5f02\u5982\u4e0b", "AccountTypeTips_0", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("1\uff09\u666e\u901a\u7c7b\uff1a\u666e\u901a\u8d26\u6237\u7c7b\u578b\uff0c\u4f7f\u7528\u6807\u51c6\u63a5\u53e3\u5b8c\u6210\u4e1a\u52a1\u5904\u7406\u3002", "AccountTypeTips_1", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("2\uff09\u5b9e\u4f53\u73b0\u91d1\u6c60\uff1a\u5b9e\u4f53\u73b0\u91d1\u6c60\u8d26\u6237\u5c06\u5207\u6362b2e006001\u5b8c\u6210\u4f59\u989d\u67e5\u8be2\u3002", "AccountTypeTips_2", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("\u6ce8\uff1a\u5982\u9700\u66f4\u6539\u8d26\u6237\u7c7b\u578b\uff0c\u8d26\u6237\u7c7b\u578b\u540c\u6b65\u9700\u8981\u4ece\u201c\u8d26\u6237\u7ba1\u7406\u201d\u6a21\u5757\u53d8\u66f4\u3002", "AccountTypeTips_3", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("\u4e1a\u52a1\u63a5\u53e3\u53ef\u4ee5\u67e5\u770b\u94f6\u884c\u63a5\u53e3\u652f\u6301\u5217\u8868\u3002", "AccountTypeTips_4", "ebg-aqap-banks-ceb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u666e\u901a\u7c7b", "BankBusinessConfig_2", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("\u5b9e\u4f53\u73b0\u91d1\u6c60", "BankBusinessConfig_3", "ebg-aqap-banks-ceb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"normal", "cashpool"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"normal"})).isAccNo(true).mustInput(true).build();
    public static final PropertyConfigItem ADD_KDTAG_ON_PAY = PropertyConfigItem.builder().key("ceb_dc_addKDtagOnPay").mlName(new MultiLangEnumBridge("\u652f\u4ed8\u662f\u5426\u9700\u8981KD\u6807\u8bb0", "BankBusinessConfig_4", "ebg-aqap-banks-ceb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u652f\u4ed8\u662f\u5426\u9700\u8981KD\u6807\u8bb0\uff0c\u7528\u4e8e\u4ed8\u6b3e\u5355\u4e0e\u4ea4\u6613\u660e\u7ec6\u8fdb\u884c\u5339\u914d\u3002", "BankBusinessConfig_36", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("1)\u662f \uff1a\u6458\u8981\u52a0\u5165KD\u6807\u8bb0\uff1b", "BankBusinessConfig_37", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("2)\u5426 \uff1a\u6458\u8981\u4e0d\u52a0\u5165KD\u6807\u8bb0\uff0c\u9ed8\u8ba4\u65b9\u5f0f\uff1b", "BankBusinessConfig_7", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u63a5\u53e3\u6709\uff1ab2e006021 \u3001b2e004001\u3002", "BankBusinessConfig_70", "ebg-aqap-banks-ceb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5426", "BankBusinessConfig_8", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("\u662f", "BankBusinessConfig_9", "ebg-aqap-banks-ceb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"false", "true"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"false"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem NEED_AUDIT_IN_NETBANK = PropertyConfigItem.builder().key("ceb_dc_needAuditInNetBank").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u662f\u5426\u9700\u8981\u5728\u7f51\u94f6\u518d\u5ba1\u6838", "BankBusinessConfig_16", "ebg-aqap-banks-ceb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u662f\u5426\u9700\u8981\u5728\u7f51\u94f6\u518d\u5ba1\u6838\uff08\u76ee\u524d\u53ea\u652f\u6301\u5bf9\u516c\u5bf9\u79c1\u548c\u5212\u62e8\u4e1a\u52a1\uff0c\u4e0d\u652f\u6301\u4ee3\u53d1\u5de5\u8d44\u548c\u59d4\u8d37\u4e1a\u52a1\uff09\u3002", "BankBusinessConfig_40", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("1\uff09\u5426\uff1a\u65e0\u9700\u5ba1\u6838\uff0c\u63d0\u4ea4\u94f6\u884c\u540e\u6267\u884c\u4ed8\u6b3e", "BankBusinessConfig_41", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("2\uff09\u662f\uff1a\u9700\u8981\u5ba1\u6838\uff0c\u63d0\u4ea4\u94f6\u884c\u540e\u9700\u8981\u518d\u7f51\u94f6\u7aef\u5ba1\u6838\u540e\u624d\u80fd\u6267\u884c\u4ed8\u6b3e", "BankBusinessConfig_19", "ebg-aqap-banks-ceb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5426", "BankBusinessConfig_8", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("\u662f", "BankBusinessConfig_9", "ebg-aqap-banks-ceb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"false", "true"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"false"})).mustInput(Boolean.TRUE.booleanValue()).build();
    public static final PropertyConfigItem CEB_DC_BALANCE_INTERFACE = PropertyConfigItem.builder().key("CEB_DC_BALANCE_INTERFACE").mlName(new MultiLangEnumBridge("\u5f53\u65e5\u4f59\u989d\u67e5\u8be2\u63a5\u53e3", "BankBusinessConfig_20", "ebg-aqap-banks-ceb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f53\u65e5\u4f59\u989d\u67e5\u8be2\u63a5\u53e3:", "BankBusinessConfig_42", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("1) \u5f53\u65e5\u4f59\u989d\u63a5\u53e3(balance)", "BankBusinessConfig_43", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("2) \u8d26\u6237\u4f59\u989d\u67e5\u8be2(b2e004031)", "BankBusinessConfig_44", "ebg-aqap-banks-ceb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f53\u65e5\u4f59\u989d\u63a5\u53e3(balance)", "BankBusinessConfig_24", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("\u8d26\u6237\u4f59\u989d\u67e5\u8be2(b2e004031)", "BankBusinessConfig_25", "ebg-aqap-banks-ceb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"balance", "b2e004031"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"b2e004031"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem PAYMENT_FIX_SERIAL_NUM = PropertyConfigItem.builder().key("payment_fix_serial_num").mlName(new MultiLangEnumBridge("\u540c\u7b14\u4ed8\u6b3e\u5355\u662f\u5426\u4f7f\u7528\u76f8\u540c\u94f6\u884c\u6d41\u6c34\u53f7\u3002", "BankBusinessConfig_26", "ebg-aqap-banks-ceb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ec5\u652f\u6301\u5355\u7b14\u63a5\u53e3\uff0c\u540c\u4e00\u7b14\u4ed8\u6b3e\u5355\u63d0\u4ea4\u7ed9\u94f6\u884c\u7684\u591a\u6b21\u4ed8\u6b3e\u6307\u4ee4\uff08\u4f8b\u5982\u5931\u8d25\u91cd\u4ed8\uff09\u53ef\u4ee5\u4f7f\u7528\u94f6\u884c\u6d41\u6c34\u53f7\u52a0\u5f3a\u91cd\u590d\u4ed8\u6b3e\u68c0\u9a8c\uff0c\u5373\u4f7f\u7528\u76f8\u540c\u6d41\u6c34\u53f7.\u63d0\u4ea4\u7ed9\u94f6\u884c\uff0c\u7531\u94f6\u884c\u7aef\u8fdb\u884c\u91cd\u590d\u4ed8\u6b3e\u6821\u9a8c\u3002", "BankBusinessConfig_27", "ebg-aqap-banks-ceb-dc")})).mlSourceNames(mlTrueFalseCN).sourceValues(trueFalseEN).defaultValues(defaultTrue).mustInput(true).build();
    private static final PropertyConfigItem ceb_dc_SALARY_SELECT = PropertyConfigItem.builder().key("SALARY_SELECT").mlName(new MultiLangEnumBridge("\u5173\u8054\u63a5\u53e3", "BankBusinessConfig_50", "ebg-aqap-banks-ceb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5df2\u5bf9\u63a5\u7684\u4ee3\u53d1\u4e1a\u52a1\u63a5\u53e3:\u3002", "BankBusinessConfig_51", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("1)\u6279\u91cf\u4ee3\u53d1\u63a5\u53e3\uff08b2e005005\uff09;", "BankBusinessConfig_52", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("2)\u4e13\u5c5e\u4ee3\u53d1\u63a5\u53e3\uff08b2e005026\uff09;", "BankBusinessConfig_54", "ebg-aqap-banks-ceb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u6279\u91cf\u4ee3\u53d1\u63a5\u53e3\uff08b2e005005\uff09", "BankBusinessConfig_53", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("\u4e13\u5c5e\u4ee3\u53d1\u63a5\u53e3\uff08b2e005026\uff09", "BankBusinessConfig_55", "ebg-aqap-banks-ceb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"b2e005005", "b2e005026"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"b2e005005"})).mustInput(true).type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName()).build();
    public static final PropertyConfigItem ceb_dc_ProtocolNum = PropertyConfigItem.builder().key("ceb_dc_ProtocolNum").mlName(new MultiLangEnumBridge("\u4ee3\u53d1\u534f\u8bae\u7f16\u53f7", "BankBusinessConfig_28", "ebg-aqap-banks-ceb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u53d1\u534f\u8bae\u7f16\u53f7\uff0c\u4e13\u5c5e\u4ee3\u53d1\u4e1a\u52a1\u4f7f\u7528\u3002\u6b64\u914d\u7f6e\u4f7f\u7528\u63a5\u53e3\u53ca\u5b57\u6bb5\u6709\uff1ab2e005005 \u6279\u91cf\u4ee3\u53d1\uff08ProtocolNum \u534f\u8bae\u7f16\u53f7\uff09\u3001b2e005026 \u4e13\u5c5e\u4ee3\u53d1\uff08ProtocolNum \u534f\u8bae\u7f16\u53f7\uff09\u3002", "BankBusinessConfig_29", "ebg-aqap-banks-ceb-dc")})).isAccNo(true).build();
    public static String PAYLLO_MODE_SALARY = "salary";
    public static String PAYLLO_MODE_OTHER = "other";
    public static final PropertyConfigItem ceb_dc_ModeCode = PropertyConfigItem.builder().key("ceb_dc_ModeCode").mlName(new MultiLangEnumBridge("\u4ee3\u53d1\u6a21\u5f0f", "BankBusinessConfig_30", "ebg-aqap-banks-ceb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u6839\u636e\u8d26\u53f7\u4e0d\u540c\u9009\u7528\u4e0d\u540c\u7684\u4ee3\u53d1\u6a21\u5f0f\uff0c\u53ef\u9009\u4ee3\u53d1\u5de5\u8d44\u4e0e\u5176\u4ed6\u4ee3\u53d1\uff08\u9ed8\u8ba4\u5176\u4ed6\u4ee3\u53d1\uff09\u3002", "BankBusinessConfig_45", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("1\uff09\u4ee3\u53d1\u5de5\u8d44/\u4e13\u5c5e\u4ee3\u53d1", "BankBusinessConfig_46", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("2\uff09\u5176\u4ed6\u4ee3\u53d1", "BankBusinessConfig_33", "ebg-aqap-banks-ceb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u53d1\u5de5\u8d44/\u4e13\u5c5e\u4ee3\u53d1", "BankBusinessConfig_34", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("\u5176\u4ed6\u4ee3\u53d1", "BankBusinessConfig_35", "ebg-aqap-banks-ceb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{PAYLLO_MODE_SALARY, PAYLLO_MODE_OTHER})).defaultValues((List)Lists.newArrayList((Object[])new String[]{PAYLLO_MODE_OTHER})).isAccNo(true).isHide(true).build();
    public static final PropertyConfigItem ceb_dc_exclusive_cif_no = PropertyConfigItem.builder().key("ceb_dc_exclusive_cif_no").mlName(new MultiLangEnumBridge("\u7f51\u94f6\u5ba2\u6237\u53f7", "BankBusinessConfig_56", "ebg-aqap-banks-ceb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u7f51\u94f6\u5ba2\u6237\u53f7\uff0c\u6807\u51c6\u4e1a\u52a1\u8bf7\u6c42\u53c2\u6570\uff0c\u6240\u6709\u4e1a\u52a1\u5747\u9700\u914d\u7f6e\u8be5\u4fe1\u606f\u3002", "BankBusinessConfig_57", "ebg-aqap-banks-ceb-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u63a5\u53e3\u53ca\u5b57\u6bb5\uff1a\u4e1a\u52a1\u6807\u51c6\u8bf7\u6c42\u62a5\u6587\uff08CifNo \u5ba2\u6237\u53f7\uff09\u5907\u6ce8\uff1a\u6b64\u4fe1\u606f\u4e3a\u516c\u53f8/\u8d26\u6237\u5c5e\u6027\uff0c\u5982\u5404\u8d26\u6237\u4e4b\u95f4\u4e00\u6837\uff0c\u5219\u53ef\u4ee5\u5728\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\u5373\u53ef\u3002\u5982\u5404\u8d26\u6237\u4e4b\u95f4\u4e0d\u4e00\u81f4\uff0c\u5219\u9700\u8981\u5728\u5404\u8d26\u6237\u7684\u9644\u52a0\u5c5e\u6027\u8fdb\u884c\u914d\u7f6e\u3002\u4e1a\u52a1\u8bf7\u6c42\u65f6\u4f18\u5148\u53d6\u503c\u8d26\u6237\u9644\u52a0\u5c5e\u6027\u7684\u6b64\u4fe1\u606f\uff0c\u5982\u679c\u8d26\u6237\u9644\u52a0\u5c5e\u6027\u5185\u6ca1\u6709\u5219\u53d6\u503c\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u5185\u7684\u6b64\u4fe1\u606f\u3002", "BankBusinessConfig_58", "ebg-aqap-banks-ceb-dc")})).isAccNo(true).build();

    public String getBankVersionID() {
        return "CEB_DC";
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List propertyConfigItems = this.getBankAddtionalPropertyConfigItems(true, true, false, true, true);
        propertyConfigItems.add(0, BANK_ACC_TYPE);
        propertyConfigItems.addAll(Lists.newArrayList((Object[])new PropertyConfigItem[]{PAYMENT_FIX_SERIAL_NUM, ADD_KDTAG_ON_PAY, NEED_AUDIT_IN_NETBANK, ceb_dc_ProtocolNum, ceb_dc_ModeCode, ceb_dc_SALARY_SELECT, CEB_DC_BALANCE_INTERFACE, ceb_dc_exclusive_cif_no, CEB_DC_has_5s_interval}));
        return propertyConfigItems;
    }

    public static boolean has5sInterval() {
        return CEB_DC_has_5s_interval.getCurrentValueAsBoolean();
    }

    public static boolean isUseBalance_b2e004031() {
        return "b2e004031".equalsIgnoreCase(CEB_DC_BALANCE_INTERFACE.getCurrentValue());
    }

    public static boolean isAuditPay() {
        return NEED_AUDIT_IN_NETBANK.getCurrentValueAsBoolean();
    }

    public static boolean isAddKDFlagToPay() {
        return ADD_KDTAG_ON_PAY.getCurrentValueAsBoolean();
    }

    public static String getProtocolNum(String payAccNo) {
        return ceb_dc_ProtocolNum.getCurrentValueWithObjectID(payAccNo);
    }

    public static String getPaylloMode(String payAccNo) {
        return ceb_dc_ModeCode.getCurrentValueWithObjectID(payAccNo);
    }

    public List<LinkPayConfig> getLinkPayConfigs() {
        return Lists.newArrayList((Object[])new LinkPayConfig[]{LinkPayConfig.ALLOCATION_AND_PAY, LinkPayConfig.NATIVE_LINK_PAY});
    }

    public static String getBatchPayInterface() {
        return ceb_dc_SALARY_SELECT.getCurrentValue();
    }

    public static String getExclusiveCifNo(String accNo) {
        return ceb_dc_exclusive_cif_no.getCurrentValueWithObjectID(accNo);
    }
}

