/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CashPoolBalanceParser {
    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Namespace namespace = root.getNamespace();
        BankAcnt acnt = rqst.getAcnt();
        Element transContent = root.getChild("TransContent", namespace);
        if (null == transContent) {
            String ReturnCode = root.getChildTextTrim("ReturnCode", namespace);
            String ReturnMsg = root.getChildTextTrim("ReturnMsg", namespace);
            String error = root.getChildTextTrim("error", namespace);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u51fa\u9519\uff1a[ReturnCode=%1$s,ReturnMsg=%2$s,error=%3$s]", (String)"CashPoolBalanceParser_5", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg, error));
        }
        String returnCode = transContent.getChildTextTrim("ReturnCode", namespace);
        String returnMsg = transContent.getChildTextTrim("ReturnMsg", namespace);
        Element data = transContent.getChild("RespData", namespace);
        String accountNo = data.getChildTextTrim("AcNo", namespace);
        String accountBalance = data.getChildTextTrim("accountBalance", namespace);
        String availableBalance = data.getChildTextTrim("availableBalance", namespace);
        String balance = data.getChildTextTrim("upbalance", namespace);
        String currency = data.getChildTextTrim("HUOBDH", namespace);
        if (!"0000".equalsIgnoreCase(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u6c60\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"CashPoolBalanceParser_6", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{returnCode, returnMsg})));
        }
        if (!acnt.getAccNo().equalsIgnoreCase(accountNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u9519\u8bef :\u8fd4\u56de\u7684\u8d26\u53f7%1$s\u4e0d\u662f\u67e5\u8be2\u8d26\u53f7%2$s\u3002", (String)"CashPoolBalanceParser_7", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), accountNo, acnt.getAccNo()));
        }
        Object[] balances = new BalanceInfo[]{new BalanceInfo()};
        balances[0].setBankAcnt(acnt);
        if (StringUtils.isEmpty((String)accountBalance) && StringUtils.isEmpty((String)balance)) {
            EBServiceException ex = EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"CashPoolBalanceParser_4", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
            throw ex;
        }
        if (!StringUtils.isEmpty((String)balance)) {
            balances[0].setCurrentBalance(new BigDecimal(balance));
        } else {
            balances[0].setCurrentBalance(new BigDecimal(accountBalance));
        }
        balances[0].setBalanceDateTime(LocalDateTime.now());
        balances[0].setBankCurrency(currency);
        if (!StringUtils.isEmpty((String)availableBalance)) {
            balances[0].setAvailableBalance(new BigDecimal(availableBalance));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])balances));
    }
}

