/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay;

import java.time.LocalDateTime;
import kd.ebg.aqap.banks.ceb.dc.utils.BankUtils;
import kd.ebg.aqap.banks.ceb.dc.utils.DateHelper;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchPayerInfos {
    public static final String DEALMODE_DAY = "1";
    public static final String DEALMODE_NIGHT = "0";
    public static final String PROCESSSTATE_PENDING = "0";
    public static final String PROCESSSTATE_PROCESSINGDATA = "1";
    public static final String PROCESSSTATE_PROCESSEDDATA = "2";
    public static final String PROCESSSTATE_PROCESSDATA_ERRO = "3";
    public static final String PROCESSSTATE_PROCESSINGBUSINESS = "4";
    public static final String PROCESSSTATE_FINISHED_OK = "5";
    public static final String PROCESSSTATE_FINISHED_ABNORMAL = "6";
    public static final String PROCESSSTATE_CANCLEED = "7";
    public static final String PROCESSSTATE_FINISHED_CONTAINSFAILED = "8";
    public static final String BUSSINESSTYPE_PAYROLLCREDIT = "0008";
    public static final String BUSSINESSTYPE_PAYROLLOTHERS = "0092";
    public static final String BUSSINESSTYPE_PAYROLLBATCH = "0169";
    public static final String CUSTOMERACCOUNT_TYPE_PUBLIC = "0";
    public static final String CUSTOMERACCOUNT_TYPE_ONCE = "A";
    public static final String CUSTOMERACCOUNT_TYPE_OTHERS = "B";
    public static final int DELAYBATCHQUERYTIME = 2;
    public static final int FILEFLAGNAME_SUCCESS = 1;
    public static final int FILEFLAGNAME_FAILED = 2;
    public static final int FILEFLAGNAME_BATCHFILE = 3;
    public static final int PAYMENTINFO_STATE_SUCCESS = 12;
    public static final int PAYMENTINFO_STATE_FAILED = 13;
    public static final String BANK_STATE_SUCCESS = "AAAAAAA";

    public static Element createSysHeader(PaymentInfo paymentInfo, String transCode, boolean checkDate) throws EBServiceException {
        Element rootElement = new Element("Transaction");
        Element sysHeadElement = JDomUtils.addChild((Element)rootElement, (String)"SystemHead");
        JDomUtils.addChild((Element)sysHeadElement, (String)"Language", (String)"zh_CN");
        JDomUtils.addChild((Element)sysHeadElement, (String)"Encodeing", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"Version", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"ServiceName", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"CifNo", (String)BankUtils.getExclusiveCifNo(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)sysHeadElement, (String)"UserID", (String)RequestContextUtils.getBankParameterValue((String)"OperatorID"));
        JDomUtils.addChild((Element)sysHeadElement, (String)"SyMacFlag", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"MAC", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"SyPinFlag", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"PinSeed", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"LicenseId", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"Flag", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"Note", (String)"");
        Element transHeadElement = JDomUtils.addChild((Element)rootElement, (String)"TransHead");
        JDomUtils.addChild((Element)transHeadElement, (String)"TransCode", (String)transCode);
        JDomUtils.addChild((Element)transHeadElement, (String)"BatchID", (String)paymentInfo.getBankBatchSeqId());
        LocalDateTime now = checkDate && null != paymentInfo.getSubmitSuccessTime() ? paymentInfo.getSubmitSuccessTime() : LocalDateTime.now();
        JDomUtils.addChild((Element)transHeadElement, (String)"JnlDate", (String)DateHelper.formatDate(now.toLocalDate()));
        JDomUtils.addChild((Element)transHeadElement, (String)"JnlTime", (String)DateHelper.formatTime(now.toLocalTime()));
        return rootElement;
    }

    public static Element createSysHeader(PaymentInfo paymentInfo, String transCode, boolean checkDate, String batchId) throws EBServiceException {
        Element rootElement = new Element("Transaction");
        Element sysHeadElement = JDomUtils.addChild((Element)rootElement, (String)"SystemHead");
        JDomUtils.addChild((Element)sysHeadElement, (String)"Language", (String)"zh_CN");
        JDomUtils.addChild((Element)sysHeadElement, (String)"Encodeing", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"Version", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"ServiceName", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"CifNo", (String)BankUtils.getExclusiveCifNo(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)sysHeadElement, (String)"UserID", (String)RequestContextUtils.getBankParameterValue((String)"OperatorID"));
        JDomUtils.addChild((Element)sysHeadElement, (String)"SyMacFlag", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"MAC", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"SyPinFlag", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"PinSeed", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"LicenseId", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"Flag", (String)"");
        JDomUtils.addChild((Element)sysHeadElement, (String)"Note", (String)"");
        Element transHeadElement = JDomUtils.addChild((Element)rootElement, (String)"TransHead");
        JDomUtils.addChild((Element)transHeadElement, (String)"TransCode", (String)transCode);
        JDomUtils.addChild((Element)transHeadElement, (String)"BatchID", (String)batchId);
        LocalDateTime now = checkDate && null != paymentInfo.getSubmitSuccessTime() ? paymentInfo.getSubmitSuccessTime() : LocalDateTime.now();
        JDomUtils.addChild((Element)transHeadElement, (String)"JnlDate", (String)DateHelper.formatDate(now.toLocalDate()));
        JDomUtils.addChild((Element)transHeadElement, (String)"JnlTime", (String)DateHelper.formatTime(now.toLocalTime()));
        return rootElement;
    }
}

