/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay.CEB_DCFileUtils;
import kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay.PayPacker;
import kd.ebg.aqap.banks.ceb.dc.services.proxy.FileDownLoad;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QueryPayParser {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public static EBBankPayResponse parseQueryPay(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        try {
            QueryPayParser.parserQueryBatchPayDetailUpload(paymentInfos, rspStr);
            return new EBBankPayResponse(paymentInfos);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private static void parserQueryBatchPayDetailUpload(List<PaymentInfo> paymentInfos, String rspStr) throws Exception {
        Namespace namespace;
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        String error = root.getChildTextTrim("error", namespace = root.getNamespace());
        if (!StringUtils.isEmpty((String)error)) {
            String ReturnCode = root.getChildTextTrim("ReturnCode", namespace);
            String ReturnMsg = root.getChildTextTrim("ReturnMsg", namespace);
            if (StringUtils.isEmpty((String)ReturnCode)) {
                EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5   ", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)"", (String)error);
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ReturnCode, (String)ReturnMsg);
            }
            return;
        }
        Element transContent = root.getChild("TransContent", namespace);
        String returnCode = transContent.getChildTextTrim("ReturnCode", namespace);
        Element respData = transContent.getChild("RespData", namespace);
        String actionStatus = respData.getChildTextTrim("ZYWTZT", namespace);
        log.info("\u94f6\u884c\u8fd4\u56de\u72b6\u6001\uff1a" + actionStatus);
        String returnMsgs = QueryPayParser.getProcessMsg(Integer.parseInt(actionStatus));
        if (!"0000".equalsIgnoreCase(returnCode)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)returnCode);
            log.info("\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u3002\u9519\u8bef\u7801\u4e3a\uff1a" + returnCode);
            return;
        }
        boolean clearFlag = false;
        if (actionStatus.equalsIgnoreCase("5")) {
            log.info("\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u5168\u90e8\u6210\u529f,\u6821\u5bf9\u91d1\u989d\u4e0e\u7b14\u6570\u3002");
            String totalCount = respData.getChildTextTrim("ZDRZBS", namespace);
            String totalAmount = respData.getChildTextTrim("ZDRZJE", namespace);
            log.info("\u6279\u6b21\u603b\u7b14\u6570\u4e3a\uff1a" + totalCount);
            log.info("\u6279\u6b21\u603b\u91d1\u989d\u4e3a\uff1a" + totalAmount);
            if (totalCount.equalsIgnoreCase(paymentInfos.size() + "") && PayPacker.getTotalAmount(paymentInfos).equalsIgnoreCase(totalAmount)) {
                log.info("\u6821\u5bf9\u7b14\u6570\u4e0e\u91d1\u989d\u5339\u914d\uff0c\u4ea4\u6613\u6210\u529f\u3002");
                clearFlag = true;
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)returnCode, (String)returnCode);
                return;
            }
            log.info("\u6821\u5bf9\u7b14\u6570\u4e0e\u91d1\u989d\u4e0d\u5339\u914d\uff0c\u542f\u7528\u6587\u4ef6\u4e0b\u8f7d\u8fdb\u884c\u5224\u65ad\u3002");
        }
        if (!clearFlag || actionStatus.equalsIgnoreCase("8")) {
            String successFileName = respData.getChildTextTrim("CGCLWJ", namespace);
            String failFileName = respData.getChildTextTrim("SBRZWJ", namespace);
            String batchFileName = respData.getChildTextTrim("PLCLWJ", namespace);
            log.info("\u6279\u91cf\u6587\u4ef6\u540d\uff1a" + batchFileName);
            log.info("\u6210\u529f\u6587\u4ef6\u540d\uff1a" + successFileName);
            log.info("\u5931\u8d25\u6587\u4ef6\u540d\uff1a" + failFileName);
            if ("".equalsIgnoreCase(successFileName) && "".equalsIgnoreCase(failFileName) && "".equalsIgnoreCase(batchFileName)) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)returnMsgs);
                log.info("\u65e0\u6cd5\u89e3\u6790\u5230\u9700\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u540d\u3002\u94f6\u884c\u8fd4\u56de\u7801\u548c\u4fe1\u606f\u4e3a\uff1a " + returnCode + "\n" + returnMsgs);
                return;
            }
            HashMap<String, PaymentInfo> map = new HashMap<String, PaymentInfo>();
            if (null != batchFileName && !"".equalsIgnoreCase(batchFileName)) {
                String[] batchFileInfo = QueryPayParser.parserFileInfo(batchFileName);
                String successFileString = QueryPayParser.getBankReturnFile(batchFileInfo[1], batchFileInfo[0], 3);
                QueryPayParser.parserDownloadFile(successFileString, map, 3);
                log.info("\u89e3\u6790\u5e76\u4e0b\u8f7d\u6279\u91cf\u660e\u7ec6\u6587\u4ef6\u3002\n" + successFileString);
            } else {
                if (null != successFileName && !"".equalsIgnoreCase(successFileName)) {
                    String[] successFileInfo = QueryPayParser.parserFileInfo(successFileName);
                    String successFileString = QueryPayParser.getBankReturnFile(successFileInfo[1], successFileInfo[0], 1);
                    QueryPayParser.parserDownloadFile(successFileString, map, 1);
                    log.info("\u89e3\u6790\u5e76\u4e0b\u8f7d\u6210\u529f\u660e\u7ec6\u6587\u4ef6\u3002\n" + successFileString);
                }
                if (null != failFileName && !"".equalsIgnoreCase(failFileName)) {
                    String[] failedFileInfo = QueryPayParser.parserFileInfo(failFileName);
                    String failedFileString = QueryPayParser.getBankReturnFile(failedFileInfo[1], failedFileInfo[0], 2);
                    QueryPayParser.parserDownloadFile(failedFileString, map, 2);
                    log.info("\u89e3\u6790\u5e76\u4e0b\u8f7d\u9519\u8bef\u660e\u7ec6\u6587\u4ef6\u3002\n" + failedFileString);
                }
            }
            QueryPayParser.setBathPayStutes(paymentInfos, map);
        } else if (actionStatus.equalsIgnoreCase("0") || actionStatus.equalsIgnoreCase("1") || actionStatus.equalsIgnoreCase("2") || actionStatus.equalsIgnoreCase("4")) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)returnMsgs);
        } else if (actionStatus.equalsIgnoreCase("3")) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)returnCode, (String)returnMsgs);
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)returnMsgs);
        }
    }

    private static String getPostHead(String fileName, String filePath) throws EBServiceException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/ent/");
        stringBuilder.append("downloadFile.do");
        stringBuilder.append("?userPassword=").append(RequestContextUtils.getBankParameterValue((String)"UserPassword"));
        stringBuilder.append("&transcode=").append("b2e005010");
        stringBuilder.append("&fileName=").append(fileName);
        stringBuilder.append("&filePath=").append(filePath);
        return stringBuilder.toString();
    }

    private static String getBankReturnFile(String fileName, String filePatch, int flag) throws Exception {
        String headMsg = QueryPayParser.getPostHead(fileName, filePatch);
        String downloadFileName = QueryPayParser.parserDownloadFileName(CEB_DCFileUtils.sendAndRecvMsg("", headMsg, ""), flag);
        FileDownLoad fileDownLoad = new FileDownLoad();
        String fileString = fileDownLoad.doBiz(downloadFileName);
        return fileString;
    }

    private static String[] parserFileInfo(String fileName) {
        String[] info = new String[]{"", ""};
        String[] str = fileName.split("/");
        for (int i = 0; i < str.length - 1; ++i) {
            info[0] = info[0] + str[i] + "/";
        }
        info[1] = str[str.length - 1];
        return info;
    }

    public static void setBathPayStutes(List<PaymentInfo> paymentInfos, Map<String, PaymentInfo> map) throws Exception {
        for (int i = 0; i < paymentInfos.size(); ++i) {
            String status;
            String id = paymentInfos.get(i).getIncomeAccNo() + "@" + paymentInfos.get(i).getAmount().toString();
            log.info("\u62fc\u63a5\u660e\u7ec6\u6761\u76ee\u552f\u4e00\u6807\u8bc6\u4e3a\u8d26\u53f7+@+\u91d1\u989d \u4e3a:" + id);
            if (map.containsKey(id)) {
                status = map.get(id).getBankMsg();
                if (!"".equalsIgnoreCase(status)) {
                    paymentInfos.get(i).setBackStatusMsg(status);
                    paymentInfos.get(i).setBankStatus(status);
                }
                if (map.get(id).getStatus() == 12) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
                    continue;
                }
                if (map.get(id).getStatus() == 13) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)"", (String)"");
                continue;
            }
            if (map.containsKey(i + 1 + "@" + paymentInfos.get(i).getIncomeAccNo() + "@" + paymentInfos.get(i).getAmount().toString())) {
                log.info("\u62fc\u63a5\u660e\u7ec6\u6761\u76ee\u552f\u4e00\u6807\u8bc6\u4e3a\u5e8f\u53f7+@+\u8d26\u53f7+@+\u91d1\u989d \u4e3a:" + (i + 1) + "@" + paymentInfos.get(i).getIncomeAccNo() + "@" + paymentInfos.get(i).getAmount().toString());
                id = i + 1 + "@" + id;
                status = map.get(id).getBankMsg();
                if (!"".equalsIgnoreCase(status)) {
                    paymentInfos.get(i).setBackStatusMsg(status);
                    paymentInfos.get(i).setBankStatus(status);
                }
                if (map.get(id).getStatus() == 12) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
                    continue;
                }
                if (map.get(id).getStatus() == 13) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)"", (String)"");
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u7ed3\u679c\u65e0\u6cd5\u5339\u914d\u8d26\u53f7\u548c\u7ed3\u679c\u3002", (String)"QueryPayParser_4", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
        }
    }

    private static String parserDownloadFileName(String resp, int state) throws EBServiceException {
        String fileName = null;
        Element transation = JDomUtils.string2Root((String)resp, (String)RequestContextUtils.getCharset());
        if (state == 1) {
            Element successFile = JDomUtils.getChildElement((Element)transation, (String)"success");
            if (null == successFile) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6\u540d\u9519\u8bef\u3002", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
            }
            fileName = successFile.getTextTrim();
        } else if (state == 2) {
            Element failedFile = JDomUtils.getChildElement((Element)transation, (String)"error");
            if (null == failedFile) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6\u540d\u9519\u8bef\u3002", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
            }
            fileName = failedFile.getTextTrim();
        } else if (state == 3) {
            Element batchFile = (Element)transation.getChildren().get(0);
            if (null == batchFile) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6\u540d\u9519\u8bef\u3002", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
            }
            fileName = batchFile.getTextTrim();
        }
        return fileName;
    }

    public static String getProcessMsg(int count) {
        String msg = null;
        switch (count) {
            case 0: {
                msg = "\u672a\u5904\u7406\u6570\u636e\u6587\u4ef6";
                break;
            }
            case 1: {
                msg = "\u6b63\u5728\u5904\u7406\u6570\u636e\u6587";
                break;
            }
            case 2: {
                msg = "\u6570\u636e\u6587\u4ef6\u5904\u7406\u6210\u529f";
                break;
            }
            case 3: {
                msg = "\u6570\u636e\u6587\u4ef6\u6709\u8bef,\u4e0d\u80fd\u8fdb\u884c";
                break;
            }
            case 4: {
                msg = "\u6b63\u5728\u5904\u7406\u4e1a\u52a1\u6570\u636e";
                break;
            }
            case 5: {
                msg = "\u6279\u91cf\u5904\u7406\u7ed3\u675f-\u5168\u90e8\u6210\u529f";
                break;
            }
            case 6: {
                msg = "\u6279\u91cf\u5904\u7406\u5f02\u5e38\u7ed3\u675f";
                break;
            }
            case 7: {
                msg = "\u64a4\u6d88";
                break;
            }
            case 8: {
                msg = "\u6279\u91cf\u5904\u7406\u7ed3\u675f-\u5b58\u5728\u5931\u8d25";
            }
        }
        return msg;
    }

    private static void parserDownloadFile(String msg, Map<String, PaymentInfo> map, int flag) {
        List<Object> stringList = new ArrayList();
        String temp = null;
        boolean startpiont = false;
        String[] lineStrings = msg.split("\n");
        for (int i = 0; i < lineStrings.length; ++i) {
            temp = lineStrings[i];
            if (temp.startsWith("-")) {
                startpiont = true;
                continue;
            }
            if (!startpiont) continue;
            stringList.add(temp);
        }
        if (stringList.isEmpty()) {
            stringList = Arrays.asList(lineStrings);
        }
        for (String string : stringList) {
            String[] tempStrings = string.split("\\|");
            if (tempStrings.length < 7) {
                throw new NullPointerException();
            }
            PaymentInfo paymentInfo = new PaymentInfo();
            paymentInfo.setAccNo(tempStrings[1]);
            paymentInfo.setAmount(new BigDecimal(tempStrings[2]));
            paymentInfo.setAccName(tempStrings[3]);
            paymentInfo.setBankMsg(tempStrings[5]);
            if (flag == 1) {
                paymentInfo.setStatus(Integer.valueOf(12));
                paymentInfo.setStatusName(PaymentState.getEnumById((int)12).getEnName());
                paymentInfo.setStatusMsg(PaymentState.getEnumById((int)12).getCnName());
            } else if (flag == 2) {
                paymentInfo.setStatus(Integer.valueOf(13));
                paymentInfo.setStatusName(PaymentState.getEnumById((int)13).getEnName());
                paymentInfo.setStatusMsg(PaymentState.getEnumById((int)13).getCnName());
            } else if (flag == 3) {
                if (tempStrings[4].equalsIgnoreCase("AAAAAAA")) {
                    paymentInfo.setStatus(Integer.valueOf(12));
                    paymentInfo.setStatusName(PaymentState.getEnumById((int)12).getEnName());
                    paymentInfo.setStatusMsg(PaymentState.getEnumById((int)12).getCnName());
                } else {
                    paymentInfo.setStatus(Integer.valueOf(13));
                    paymentInfo.setStatusName(PaymentState.getEnumById((int)13).getEnName());
                    paymentInfo.setStatusMsg(PaymentState.getEnumById((int)13).getCnName());
                }
            }
            if (map.containsKey(tempStrings[1] + "@" + tempStrings[2])) {
                map.put(tempStrings[0] + "@" + tempStrings[1] + "@" + tempStrings[2], paymentInfo);
                continue;
            }
            map.put(tempStrings[1] + "@" + tempStrings[2], paymentInfo);
        }
    }
}

