/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.newbatchPay;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay.BatchPayerInfos;
import kd.ebg.aqap.banks.ceb.dc.utils.BankUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QueryInnerAccountNo
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element rootElement = BatchPayerInfos.createSysHeader((PaymentInfo)paymentInfos.get(0), "b2e005025", false, BankUtils.createBatchID());
        Element transContentElement = JDomUtils.addChild((Element)rootElement, (String)"TransContent");
        Element reqDataElement = JDomUtils.addChild((Element)transContentElement, (String)"ReqData");
        JDomUtils.addChild((Element)reqDataElement, (String)"ClientPatchID", (String)BankUtils.createBatchID());
        JDomUtils.addChild((Element)reqDataElement, (String)"IssuAcNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)reqDataElement, (String)"StartNum", (String)"1");
        JDomUtils.addChild((Element)reqDataElement, (String)"QueryNum", (String)"10");
        String xmlMsg = JDomUtils.root2String((Element)rootElement, (String)"GBK");
        return xmlMsg;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Namespace namespace = root.getNamespace();
        Element TransContent = root.getChild("TransContent", namespace);
        String ReturnCode = TransContent.getChildTextTrim("ReturnCode", namespace);
        String ReturnMsg = TransContent.getChildTextTrim("ReturnMsg", namespace);
        if ("0000".equals(ReturnCode)) {
            Element batchResp = TransContent.getChild("BatchRespList", namespace);
            List RespDataList = batchResp.getChildren("RespData", namespace);
            if (CollectionUtil.isNotEmpty((Collection)RespDataList)) {
                Element element = (Element)RespDataList.get(0);
                String accountNo = element.getChildText("XIOZXH", namespace);
                if (StringUtils.isEmpty((String)accountNo)) {
                    throw new EBServiceException(ResManager.loadKDString((String)"\u5f85\u9500\u8d26\u5e8f\u53f7\u4e3a\u7a7a\u3002", (String)"QueryInnerAccountNo_0", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
                }
                RequestContextUtils.setRunningParam((String)"XZAccountNo", (String)accountNo);
            }
        } else {
            throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5f85\u9500\u8d26\u5e8f\u53f7\u5931\u8d25:%1$s", (String)"QueryInnerAccountNo_2", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), ReturnMsg));
        }
        return new EBBankPayResponse();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e005025";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f85\u9500\u8d26\u5e8f\u53f7\u3002", (String)"QueryInnerAccountNo_3", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        StringBuilder builder = new StringBuilder();
        builder.append("/ent/b2e005025.do").append("?userPassword=").append(RequestContextUtils.getBankParameterValue((String)"UserPassword")).append("&Sigdata=").append("1");
        factory.setUri(builder.toString());
        return factory;
    }
}

