/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fbbk.api.services.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import kd.ebg.aqap.banks.fbbk.api.services.utils.JAVA_SDK_SecurityUtils;
import kd.ebg.aqap.banks.fbbk.api.services.utils.SM2Utils;
import kd.ebg.aqap.banks.fbbk.api.services.utils.SM3;
import kd.ebg.aqap.banks.fbbk.api.services.utils.SM4Utils;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Util;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;

public class Packer {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(Packer.class);

    public static JSONObject packHeader() {
        JSONObject headJson = new JSONObject();
        headJson.put("merchant", (Object)RequestContextUtils.getBankParameterValue((String)"app_id"));
        return headJson;
    }

    public static String encrytAndSign(String reqData) throws IOException {
        byte[] randomKey = Util.genarateRandomKey();
        String sign = JAVA_SDK_SecurityUtils.encryptByBASE64(SM2Utils.sign(randomKey, Util.hexToByte(Packer.getSM2Key("merchant_private_key")), SM3.hash(reqData.getBytes(StandardCharsets.UTF_8))));
        String scrtKey = JAVA_SDK_SecurityUtils.encryptByBASE64(SM2Utils.encrypt(Util.hexToByte(Packer.getSM2Key("bank_public_key")), randomKey));
        logger.info("\u52a0\u5bc6\u524d\u62a5\u6587:" + reqData);
        String reqDataScr = JAVA_SDK_SecurityUtils.encryptByBASE64(SM4Utils.encryptData_ECB(reqData.getBytes(StandardCharsets.UTF_8), randomKey));
        JSONObject json = new JSONObject();
        json.put("sequenceNo", (Object)Sequence.gen18Sequence());
        json.put("timestamp", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")));
        json.put("signature", (Object)sign);
        json.put("encryptedKey", (Object)scrtKey);
        json.put("encryptedData", (Object)reqDataScr);
        return json.toJSONString();
    }

    public static String getSM2Key(String bankConfigID) {
        if (EBContext.getContext().isUnitTest()) {
            if ("merchant_private_key".equals(bankConfigID)) {
                return "00d51b84570949305352a21b55e45a339c90273fbf3b2899664fe2611cbb6838a4";
            }
            if ("bank_public_key".equals(bankConfigID)) {
                return "040DD4223BB6382DB2F1F6652E3C6681DA0F41285180ED8105D9BDD5FDFFC1FFFDA56F569C87F512C877170BA5FA0F15470F07CB377CD45D3B6C86054A1129D7DA";
            }
        }
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(bankConfigID, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        CipherInfo cipherInfo = Packer.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return StringUtils.byteToString((byte[])fileContent);
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }
}

