/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fbbk.api.services.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import kd.ebg.aqap.banks.fbbk.api.services.utils.JAVA_SDK_SecurityUtils;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Packer;
import kd.ebg.aqap.banks.fbbk.api.services.utils.SM2Utils;
import kd.ebg.aqap.banks.fbbk.api.services.utils.SM3;
import kd.ebg.aqap.banks.fbbk.api.services.utils.SM4Utils;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Util;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;

public class Parser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(Parser.class);

    public static BankResponse getResponse(String response) {
        JSONObject request = JSONObject.parseObject((String)response);
        String resultcode = (String)request.get((Object)"code");
        String resultmsg = (String)request.get((Object)"message");
        BankResponse res = new BankResponse();
        res.setResponseCode(resultcode);
        res.setResponseMessage(resultmsg);
        return res;
    }

    public static String decryAndSignCheck(String responseStr) throws IOException {
        if (EBContext.getContext().isUnitTest()) {
            return responseStr;
        }
        JSONObject reqJson = JSON.parseObject((String)responseStr);
        String reqKey = reqJson.getString("encryptedKey");
        String encryptedData = reqJson.getString("encryptedData");
        String signature = reqJson.getString("signature");
        byte[] randomKey2 = SM2Utils.decrypt(Util.hexToByte(Packer.getSM2Key("merchant_private_key")), JAVA_SDK_SecurityUtils.decryptByBASE64(reqKey));
        String keyStr2 = JAVA_SDK_SecurityUtils.encryptByBASE64(randomKey2);
        String plainResponseStr = new String(SM4Utils.decryptData_ECB(JAVA_SDK_SecurityUtils.decryptByBASE64(encryptedData), randomKey2), StandardCharsets.UTF_8).trim();
        logger.info("\u89e3\u5bc6\u540e\u62a5\u6587:" + plainResponseStr);
        boolean flag = SM2Utils.verifySign(randomKey2, Util.hexToByte(Packer.getSM2Key("bank_public_key")), SM3.hash(plainResponseStr.getBytes()), JAVA_SDK_SecurityUtils.decryptByBASE64(signature));
        logger.info("\u62a5\u6587\u9a8c\u8bc1\u7b7e\u540d\u7ed3\u679c:" + flag);
        return plainResponseStr;
    }
}

