/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fbbk.api.services.utils;

import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Locale;
import kd.ebg.aqap.banks.fbbk.api.services.utils.SM2Result;
import kd.ebg.aqap.banks.fbbk.api.services.utils.SM3Digest;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Util;
import kd.ebg.egf.common.log.EBGLogger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class SM2 {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SM2.class);
    public static String[] ecc_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    public final BigInteger ecc_p = new BigInteger(ecc_param[0], 16);
    public final BigInteger ecc_a = new BigInteger(ecc_param[1], 16);
    public final BigInteger ecc_b = new BigInteger(ecc_param[2], 16);
    public final BigInteger ecc_n = new BigInteger(ecc_param[3], 16);
    public final BigInteger ecc_gx = new BigInteger(ecc_param[4], 16);
    public final BigInteger ecc_gy = new BigInteger(ecc_param[5], 16);
    public ECCurve ecc_curve;
    public ECPoint ecc_point_g;
    public ECDomainParameters ecc_bc_spec;
    public ECKeyPairGenerator ecc_key_pair_generator;
    public ECFieldElement ecc_gx_fieldelement;
    public ECFieldElement ecc_gy_fieldelement;

    public static SM2 Instance() {
        return new SM2();
    }

    public SM2() {
        ECPoint.Fp ecc_point_g1 = null;
        try {
            Class<ECPoint.Fp> clazz = ECPoint.Fp.class;
            Constructor c1 = clazz.getDeclaredConstructor(ECCurve.class, ECFieldElement.class, ECFieldElement.class);
            c1.setAccessible(true);
            Class<ECFieldElement.Fp> clazz2 = ECFieldElement.Fp.class;
            Constructor c2 = clazz2.getDeclaredConstructor(BigInteger.class, BigInteger.class, BigInteger.class);
            c2.setAccessible(true);
            BigInteger r = SM2.calculateResidue(this.ecc_p);
            this.ecc_gx_fieldelement = (ECFieldElement.Fp)c2.newInstance(this.ecc_p, r, this.ecc_gx);
            this.ecc_gy_fieldelement = (ECFieldElement.Fp)c2.newInstance(this.ecc_p, r, this.ecc_gy);
            this.ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b);
            ecc_point_g1 = (ECPoint.Fp)c1.newInstance(this.ecc_curve, this.ecc_gx_fieldelement, this.ecc_gy_fieldelement);
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316SM2\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
        }
        this.ecc_point_g = ecc_point_g1;
        this.ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n);
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)ecc_ecgenparam);
    }

    public static BigInteger calculateResidue(BigInteger p) {
        BigInteger firstWord;
        int bitLength = p.bitLength();
        if (bitLength >= 96 && (firstWord = p.shiftRight(bitLength - 64)).longValue() == -1L) {
            return ECConstants.ONE.shiftLeft(bitLength).subtract(p);
        }
        return null;
    }

    public byte[] sm2GetZ(byte[] userId, ECPoint userKey) {
        SM3Digest sm3 = new SM3Digest();
        int len = userId.length * 8;
        sm3.update((byte)(len >> 8 & 0xFF));
        sm3.update((byte)(len & 0xFF));
        sm3.update(userId, 0, userId.length);
        byte[] p = Util.byteConvert32Bytes(this.ecc_a);
        sm3.update(p, 0, p.length);
        p = Util.byteConvert32Bytes(this.ecc_b);
        sm3.update(p, 0, p.length);
        p = Util.byteConvert32Bytes(this.ecc_gx);
        sm3.update(p, 0, p.length);
        p = Util.byteConvert32Bytes(this.ecc_gy);
        sm3.update(p, 0, p.length);
        p = Util.byteConvert32Bytes(userKey.normalize().getXCoord().toBigInteger());
        sm3.update(p, 0, p.length);
        p = Util.byteConvert32Bytes(userKey.normalize().getYCoord().toBigInteger());
        sm3.update(p, 0, p.length);
        byte[] md = new byte[sm3.getDigestSize()];
        sm3.doFinal(md, 0);
        return md;
    }

    public void sm2Sign(byte[] md, BigInteger userD, ECPoint userKey, SM2Result sm2Result) {
        BigInteger e = new BigInteger(1, md);
        BigInteger k = null;
        ECPoint kp = null;
        BigInteger r = null;
        BigInteger s = null;
        while (true) {
            AsymmetricCipherKeyPair keypair = this.ecc_key_pair_generator.generateKeyPair();
            ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
            ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keypair.getPublic();
            k = ecpriv.getD();
            kp = ecpub.getQ();
            r = e.add(kp.normalize().getXCoord().toBigInteger());
            if ((r = r.mod(this.ecc_n)).equals(BigInteger.ZERO) || r.add(k).equals(this.ecc_n)) continue;
            BigInteger da_1 = userD.add(BigInteger.ONE);
            da_1 = da_1.modInverse(this.ecc_n);
            s = r.multiply(userD);
            s = k.subtract(s).mod(this.ecc_n);
            if (!(s = da_1.multiply(s).mod(this.ecc_n)).equals(BigInteger.ZERO)) break;
        }
        sm2Result.r = r;
        sm2Result.s = s;
    }

    public void sm2Verify(byte[] md, ECPoint userKey, BigInteger r, BigInteger s, SM2Result sm2Result) {
        sm2Result.R = null;
        BigInteger e = new BigInteger(1, md);
        BigInteger t = r.add(s).mod(this.ecc_n);
        if (!t.equals(BigInteger.ZERO)) {
            ECPoint x1y1 = this.ecc_point_g.multiply(sm2Result.s);
            x1y1 = x1y1.add(userKey.multiply(t));
            sm2Result.R = e.add(x1y1.normalize().getXCoord().toBigInteger()).mod(this.ecc_n);
        }
    }

    public static int byteToInt(byte[] bytes) {
        int num = 0;
        int temp = (0xFF & bytes[0]) << 0;
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = (byte)byteint;
            ++i;
            ++j;
        }
        return b;
    }

    public static String byteToHex(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        StringBuilder hs = new StringBuilder();
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
                continue;
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase(Locale.ENGLISH);
    }
}

