/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dlb.dc.service.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dlb.dc.utils.DLBUtils;
import kd.ebg.aqap.banks.dlb.dc.utils.DLB_DC_Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        String req_no = Sequence.gen18Sequence();
        Element ap = DLB_DC_Packer.builedHead("416B600002", req_no);
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)bankBalanceRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"acno", (String)bankBalanceRequest.getAcnt().getAccNo());
        String xmlString = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        String xmlInfo = DLBUtils.forStringLengthByte(xmlString);
        return xmlInfo;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        rspStr = rspStr.substring(12);
        BankResponse rsp = new BankResponse();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        rsp.setResponseCode(succ_flag + "_" + ret_code);
        rsp.setResponseMessage(ret_info);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s,%2$s", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = ap.getChild("body");
        String acno = body.getChildText("acno");
        if (!bankBalanceRequest.getAcnt().getAccNo().equalsIgnoreCase(acno)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25,\u539f\u56e0:\u8bf7\u6c42\u8d26\u53f7\u4e0e\u94f6\u884c\u54cd\u5e94\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]));
        }
        List bodys = ap.getChildren("body");
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(16);
        for (int i = 0; i < bodys.size(); ++i) {
            BalanceInfo balanceInfo = new BalanceInfo();
            Element element = (Element)bodys.get(i);
            String balance = element.getChildTextTrim("balance");
            String use_balance = element.getChildTextTrim("use_balance");
            balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
            balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
            balanceInfoList.add(balanceInfo);
            if (!StringUtils.isEmpty((String)balance)) {
                balanceInfo.setCurrentBalance(new BigDecimal(balance));
            } else {
                String resMsg = ShowTipUtil.getBalanceEmptyTips((String)"balance");
                balanceInfo.setError(resMsg);
            }
            if (!StringUtils.isEmpty((String)use_balance)) {
                balanceInfo.setAvailableBalance(new BigDecimal(use_balance));
            }
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
        }
        return new EBBankBalanceResponse(balanceInfoList);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "416B600002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]);
    }
}

