/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dlb.dc.service.payment.company;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dlb.dc.utils.DLBUtils;
import kd.ebg.aqap.banks.dlb.dc.utils.DLB_DC_Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f01\u4e1a\u4ea4\u6613\u6d41\u6c34\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u8be2\u3002", (String)"CompanyQueryPayImpl_0", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]));
        }
        Element ap = DLB_DC_Packer.builedHead("416B3011", Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)paymentInfo.getBankBatchSeqId());
        String tr_acdt = paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)tr_acdt);
        String xmlInfo = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)"UTF-8");
        xmlInfo = DLBUtils.forStringLengthByte(xmlInfo);
        return xmlInfo;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        rspStr = rspStr.substring(12);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = new BankResponse();
        Element head = root.getChild("head");
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String ext_info = head.getChildTextTrim("ext_info");
        rsp.setResponseCode(succ_flag + "_" + ret_code);
        rsp.setResponseMessage(ret_info + ";" + ext_info);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element body = root.getChild("body");
            String stat = body.getChildTextTrim("stat");
            String error_info = body.getChildTextTrim("ret_info");
            if ("6".equalsIgnoreCase(stat)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), (String)stat, (String)error_info);
            } else if ("9".equalsIgnoreCase(stat)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), (String)stat, (String)error_info);
            } else if ("3".equalsIgnoreCase(stat)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyQueryPayImpl_4", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), (String)stat, (String)error_info);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), (String)stat, (String)error_info);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "416B3011";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u4ed8\u6b3e\u67e5\u8be2", (String)"CompanyQueryPayImpl_5", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]);
    }
}

