/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        if ("fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u4f59\u989d\u4e0d\u652f\u6301\u67e5\u8be2\u5386\u53f2\u4f59\u989d\u3002", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element in = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element st = JDomUtils.addChild((Element)in, (String)"HISBALQUERYTRNRQ");
        String packageID = RequestContextUtils.getRequestContext().getBankRequestSeq();
        JDomUtils.addChild((Element)st, (String)"TRNUID", (String)packageID);
        Element rd = JDomUtils.addChild((Element)st, (String)"HISBALQUERYRQ");
        Element ad = JDomUtils.addChild((Element)rd, (String)"HISBALQUERYINFO");
        JDomUtils.addChild((Element)ad, (String)"ACCTID", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)ad, (String)"DTSTART", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)ad, (String)"DTEND", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)cms, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element SIGNONMSGSRSV1 = root.getChild("SIGNONMSGSRSV1");
        if (SIGNONMSGSRSV1 != null) {
            String CODE = SIGNONMSGSRSV1.getChild("SONRS").getChild("STATUS").getChildText("CODE");
            String MESSAGE = SIGNONMSGSRSV1.getChild("SONRS").getChild("STATUS").getChildText("MESSAGE");
            if (!"0".equals(CODE.trim())) {
                throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)CODE, (String)MESSAGE));
            }
        }
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("HISBALQUERYTRNRS");
        Element status = eb.getChild("STATUS");
        String iRetCode = status.getChildTextTrim("CODE");
        String msg = status.getChildTextTrim("MESSAGE");
        ArrayList<BalanceInfo> result = new ArrayList<BalanceInfo>(16);
        if (!"0".equals(iRetCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)iRetCode, (String)msg));
        }
        Element rs = eb.getChild("HISBALQUERYRS");
        Element info = JDomUtils.getChildElement((Element)rs, (String)"HISBALQUERYINFO");
        String accNo = JDomUtils.getChildText((Element)info, (String)"ACCTID");
        Element details = JDomUtils.getChildElement((Element)info, (String)"DETAILS");
        List detailList = details.getChildren("DETAIL");
        for (Element detail : detailList) {
            String hisBalanceStr = JDomUtils.getChildText((Element)detail, (String)"HISBALANCE");
            String dateStr = JDomUtils.getChildText((Element)detail, (String)"DTFLOW");
            BalanceInfo balance = new BalanceInfo();
            this.setBankAcnt(balance, request.getBankAcntList(), accNo);
            balance.setBankCurrency(request.getBankCurrency());
            balance.setBalanceDateTime(LocalDateTime.parse(dateStr + "235959", DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss")));
            this.setCurrentBalance(balance, hisBalanceStr);
            result.add(balance);
        }
        return new EBBankBalanceResponse(result);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d", (String)"HisBalanceImpl_7", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]);
    }
}

