/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.balancereconciliation;

import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceReconciliationImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceReconciliationImpl
extends AbstractBalanceReconciliationImpl
implements IBalanceReconciliation {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceReconciliationImpl.class);

    public String pack(BankBalanceReconciliationRequest request) {
        BalanceReconciliationDetail detail = request.getDetail();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element in = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element ct = JDomUtils.addChild((Element)in, (String)"BALANCECHECKTRNRQ");
        String packageID = RequestContextUtils.getRequestContext().getBankRequestSeq();
        JDomUtils.addChild((Element)ct, (String)"TRNUID", (String)packageID);
        Element rqbody = JDomUtils.addChild((Element)ct, (String)"RQBODY");
        JDomUtils.addChild((Element)rqbody, (String)"INTFC_TYPE", (String)"0");
        JDomUtils.addChild((Element)rqbody, (String)"BILL_NO", (String)detail.getStatementNo());
        JDomUtils.addChild((Element)rqbody, (String)"RECONCILE_ACCOUNT", (String)detail.getAccNo());
        JDomUtils.addChild((Element)rqbody, (String)"RECONCILE_STATUS", (String)"1");
        detail.setSys("ref", packageID);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)cms, (String)encoding);
    }

    public EBBankBalanceReconciliationResponse parse(BankBalanceReconciliationRequest bankBalanceReconciliationRequest, String s) {
        BalanceReconciliationDetail detail = bankBalanceReconciliationRequest.getDetail();
        Element root = CIB_DC_Parser.parseString2Root(s);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("BALANCECHECKTRNRS");
        Element rsbody = eb.getChild("RSBODY");
        String reconcile_result = rsbody.getChildText("RECONCILE_RESULT");
        String reconcile_result_msg = rsbody.getChildText("RECONCILE_RESULT_MSG");
        ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUBMITED, (String)reconcile_result, (String)reconcile_result_msg);
        return new EBBankBalanceReconciliationResponse(detail);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BALANCECHECKTRNRQ";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankBalanceReconciliationRequest request) {
        return true;
    }
}

