/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.company;

import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.entity.biz.status.UpdateOpState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class Pay_Company_Parser {
    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element xfe;
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("XFERTRNRS");
        String packageId = eb.getChildText("TRNUID");
        Element pub = eb.getChild("STATUS");
        String recode = pub.getChildTextTrim("CODE");
        String reMessage = pub.getChildTextTrim("MESSAGE");
        String errorMessage = pub.getChildText("MESSAGE");
        String bankCode = recode;
        String bankMsg = StringUtils.isEmpty((String)reMessage) ? errorMessage : reMessage;
        Element er = eb.getChild("XFERRS");
        String xferprCode = null;
        String message = "";
        if (null != er && null != (xfe = er.getChild("XFERPRCSTS"))) {
            xferprCode = xfe.getChildText("XFERPRCCODE");
            message = xfe.getChildText("MESSAGE");
        }
        String responseCode = null;
        String responseMsg = message;
        if (!StringUtils.isEmpty((String)recode) && "0".equalsIgnoreCase(recode)) {
            responseCode = xferprCode;
        } else if (!StringUtils.isEmpty((String)recode) && "10514".equalsIgnoreCase(recode)) {
            responseCode = "AUDITING";
        } else if (!StringUtils.isEmpty((String)recode) && "2000".equalsIgnoreCase(recode)) {
            paymentInfos[0].setUpdateOperation(UpdateOpState.PAY_FAIL.getId());
            responseCode = "FAIL";
        } else {
            responseCode = "AUDITING";
        }
        if (!StringUtils.isEmpty((String)responseMsg)) {
            bankMsg = responseMsg;
        }
        if (!StringUtils.isEmpty((String)xferprCode)) {
            bankCode = xferprCode;
        }
        if ("PAYOUT".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUCCESS, (String)"", (String)bankCode, (String)bankMsg);
        } else if ("AUDITING".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankCode, (String)bankMsg);
        } else if ("FAIL".equalsIgnoreCase(responseCode) || "CANCEL".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentFailState((PaymentInfo)paymentInfos[0], (String)"", (String)bankCode, (String)bankMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankCode, (String)bankMsg);
        }
    }
}

