/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.oversea;

import java.util.HashMap;
import java.util.Map;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.file.AbstractAttachmentHttpImpl;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AttachmentUploadImpl
extends AbstractAttachmentHttpImpl {
    public String getUploadUri() {
        return "/upload";
    }

    public Map<String, String> getUploadBody() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bizCode", "101");
        return map;
    }

    public String getBinaryBodyName() {
        return "file";
    }

    public void parseUpload(PayAttachment payAttachment, String s) {
        Element element = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element file_info = element.getChild("FILE_INFO");
        String file_id = JDomUtils.getChildText((Element)file_info, (String)"FILE_ID");
        payAttachment.setFileID(file_id);
    }

    public String pack(PayAttachment payAttachment) {
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element in = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element st = JDomUtils.addChild((Element)in, (String)"OUTREMITIMGUPLOADTRNRQ");
        JDomUtils.addChild((Element)st, (String)"TRNUID", (String)Sequence.genSequence());
        Element rqbody = JDomUtils.addChild((Element)st, (String)"RQBODY");
        JDomUtils.addChild((Element)rqbody, (String)"CLT_REF_NO", (String)payAttachment.getBankDetailSeqID());
        Element content = JDomUtils.addChild((Element)rqbody, (String)"CONTENT");
        JDomUtils.addChild((Element)content, (String)"FILE_ID", (String)payAttachment.getFileID());
        JDomUtils.addChild((Element)content, (String)"FILE_NAME", (String)payAttachment.getFileName());
        return JDomUtils.root2String((Element)cms, (String)RequestContextUtils.getCharset());
    }

    public void parse(PayAttachment payAttachment, String s) {
        Element root = CIB_DC_Parser.parseString2Root(s);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element outremitimguploadtrnrs = eb1.getChild("OUTREMITIMGUPLOADTRNRS");
        Element status = outremitimguploadtrnrs.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)status, (String)"CODE");
        String message = JDomUtils.getChildText((Element)status, (String)"MESSAGE");
        if ("0".equalsIgnoreCase(code)) {
            this.setUploadStatus(payAttachment, AttachmentState.SUCCESS, code, message);
        } else {
            this.setUploadStatus(payAttachment, AttachmentState.UNKNOWN, code, message);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

