/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.utils;

import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;

public class BankUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankUtils.class);
    public static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean isTransfer(PaymentInfo paymentInfo) throws EBServiceException {
        String useCode = paymentInfo.getUseCode();
        String useCn = paymentInfo.getUseCn();
        if ("-1".equalsIgnoreCase(useCode)) {
            return ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"BankUtils_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]).equalsIgnoreCase(useCn) || ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"BankUtils_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]).equalsIgnoreCase(useCn);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u53f7%S\u3002", (String)"BankUtils_7", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), paymentInfo.getUseCode()));
    }

    public static boolean isTransUp(PaymentInfo paymentInfo) throws EBServiceException {
        String useCode = paymentInfo.getUseCode();
        String useCn = paymentInfo.getUseCn();
        if ("-1".equalsIgnoreCase(useCode)) {
            if (!BankUtils.isTransfer(paymentInfo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u9519\u8bef\uff0c\u4e0d\u662f\u8d44\u91d1\u4e0a\u5212\u4e0e\u8d44\u91d1\u4e0b\u62e8\u3002", (String)"BankUtils_3", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
            }
            return ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"BankUtils_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]).equalsIgnoreCase(useCn);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u7801%s\u3002", (String)"BankUtils_8", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), paymentInfo.getUseCode()));
    }

    public static boolean isSalary(PaymentInfo paymentInfo) throws EBServiceException {
        if ("-1".equalsIgnoreCase(paymentInfo.getUseCode())) {
            return ResManager.loadKDString((String)"\u5de5\u8d44", (String)"BankUtils_4", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]).equalsIgnoreCase(paymentInfo.getUseCn());
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u7801%s\u3002", (String)"BankUtils_8", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), paymentInfo.getUseCode()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMD5(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[2048];
            int length = -1;
            long s = System.currentTimeMillis();
            while ((length = fis.read(buffer)) != -1) {
                md.update(buffer, 0, length);
            }
            byte[] b = md.digest();
            String string = BankUtils.byteToHexString(b);
            return string;
        }
        catch (Exception ex) {
            logger.error("md5\u5f02\u5e38", (Throwable)ex);
            return null;
        }
    }

    private static String byteToHexString(byte[] tmp) {
        char[] str = new char[32];
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            byte byte0 = tmp[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        String s = new String(str);
        return s;
    }

    public static String getBankVersionConfigPath() {
        EBContext context = EBContext.getContext();
        String customID = context.getCustomID();
        String storageRootPath = System.getProperty("user.dir");
        BankUtils.checkAndCreatePath(storageRootPath + File.separator + "cib" + File.separator + customID);
        return storageRootPath + File.separator + "cib" + File.separator + customID;
    }

    private static void checkAndCreatePath(String path) {
        File file = FileCommonUtils.getFileByPath((String)path);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u521b\u5efa\u8def\u5f84: %s\u53d1\u751f\u5f02\u5e38\u3002", (String)"BankUtils_9", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), path), (Throwable)e);
            }
        }
    }
}

