/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Iterator;
import kd.ebg.aqap.banks.hsbl.dc.HsblMetaDataImpl;
import kd.ebg.aqap.banks.hsbl.dc.service.api.GetKeyStoreHelper;
import kd.ebg.aqap.proxy.oversea.utils.PgpHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.sdk.ebg.trd.proxy.pgp.SDKPrivateKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKPublicKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKSecretKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public class HsblPgpHelper {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HsblPgpHelper.class);
    private static BouncyCastleProvider bouncyCastleProvider = null;
    private static HsblPgpHelper instance;

    public static synchronized BouncyCastleProvider getProviderInstance() {
        if (bouncyCastleProvider == null) {
            bouncyCastleProvider = new BouncyCastleProvider();
        }
        return bouncyCastleProvider;
    }

    private HsblPgpHelper() {
    }

    public static synchronized HsblPgpHelper getInstance() {
        if (instance == null) {
            instance = new HsblPgpHelper();
        }
        return instance;
    }

    public static String encry(String fileContent) throws Exception {
        logger.info("\u8bf7\u6c42\u539f\u6587\uff1a" + fileContent);
        if (EBContext.getContext().isUnitTest()) {
            return fileContent;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(fileContent.getBytes(RequestContextUtils.getCharset()));
        PgpHelper pgp = PgpHelper.getInstance();
        SDKSecretKey secretKey = pgp.readSecretKey(IOUtils.toInputStream((String)GetKeyStoreHelper.getPgpPrivateKey()));
        SDKPrivateKey prKey = pgp.findSecretKey(secretKey, RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.privateKeyPd).toCharArray());
        SDKPublicKey puKey = pgp.readPublicKey(IOUtils.toInputStream((String)GetKeyStoreHelper.getPgpPublicKey()));
        pgp.encryptAndSign((OutputStream)out, (InputStream)in, puKey, prKey);
        String encode = out.toString(RequestContextUtils.getCharset());
        return Base64.encodeBase64String((byte[])encode.getBytes()).replaceAll("\r|\n", "");
    }

    public static String decry(String fileContent) throws Exception {
        if (EBContext.getContext().isUnitTest()) {
            return new String(Base64.decodeBase64((String)fileContent));
        }
        byte[] ret = Base64.decodeBase64((String)fileContent);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(ret);
        InputStream keyIn = IOUtils.toInputStream((String)GetKeyStoreHelper.getPgpPrivateKey());
        String pd = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.privateKeyPd);
        PgpHelper pgp = PgpHelper.getInstance();
        pgp.decryptStream((InputStream)in, (OutputStream)out, keyIn, pd.toCharArray());
        return out.toString(RequestContextUtils.getCharset());
    }

    public PGPPublicKey readPublicKey(InputStream in) throws IOException, PGPException {
        try (InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)in);){
            PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey key = null;
            Iterator rIt = pgpPub.getKeyRings();
            while (key == null && rIt.hasNext()) {
                PGPPublicKeyRing kRing = (PGPPublicKeyRing)rIt.next();
                Iterator kIt = kRing.getPublicKeys();
                while (kIt.hasNext()) {
                    PGPPublicKey k = (PGPPublicKey)kIt.next();
                    System.out.println("Is Encryption Key =" + k.isEncryptionKey());
                    System.out.println("Is Master Key =" + k.isMasterKey());
                    System.out.println("Is Revoked Key =" + k.isRevoked());
                    System.out.println(" Key ID =" + k.getKeyID());
                    System.out.println(" Key Strength =" + k.getBitStrength());
                    if (!k.isEncryptionKey()) continue;
                    key = k;
                }
            }
            if (key == null) {
                throw new IllegalArgumentException("Can't find encryption key in key ring.");
            }
            PGPPublicKey pGPPublicKey = key;
            return pGPPublicKey;
        }
    }

    public boolean verifySignature(InputStream data, byte[] b, PGPPublicKey key) throws GeneralSecurityException, IOException, PGPException {
        PGPObjectFactory pgpFact = new PGPObjectFactory(b, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPSignatureList p3 = null;
        Object o = pgpFact.nextObject();
        if (o instanceof PGPCompressedData) {
            PGPCompressedData c1 = (PGPCompressedData)o;
            try (InputStream dataStream = c1.getDataStream();){
                pgpFact = new PGPObjectFactory(dataStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                p3 = (PGPSignatureList)pgpFact.nextObject();
            }
        } else {
            p3 = (PGPSignatureList)o;
        }
        if (p3 != null) {
            PGPSignature sig = p3.get(0);
            sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider((Provider)HsblPgpHelper.getProviderInstance()), key);
            sig.update(IOUtils.toByteArray((InputStream)data));
            data.close();
            return sig.verify();
        }
        return false;
    }

    public byte[] createSignature(InputStream fIn, PGPPrivateKey keyIn, boolean armor) throws GeneralSecurityException, IOException, PGPException {
        PGPSignatureGenerator sGen = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(keyIn.getPublicKeyPacket().getAlgorithm(), 10).setProvider((Provider)HsblPgpHelper.getProviderInstance()));
        sGen.init(0, keyIn);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ArmoredOutputStream aOut = new ArmoredOutputStream((OutputStream)byteOut);
        sGen.update(IOUtils.toByteArray((InputStream)fIn));
        aOut.endClearText();
        fIn.close();
        BCPGOutputStream bOut = new BCPGOutputStream((OutputStream)byteOut);
        sGen.generate().encode((OutputStream)bOut);
        if (armor) {
            aOut.close();
        }
        return byteOut.toByteArray();
    }

    public PGPPrivateKey findSecretKey(PGPSecretKey pgpSecKey, char[] pass) throws IOException, PGPException, NoSuchProviderException {
        return pgpSecKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider((Provider)HsblPgpHelper.getProviderInstance()).build(pass));
    }

    static PGPPrivateKey findSecretKey(PGPSecretKeyRingCollection pgpSec, long keyID, char[] pass) throws PGPException, NoSuchProviderException {
        PGPSecretKey pgpSecKey = pgpSec.getSecretKey(keyID);
        if (pgpSecKey == null) {
            return null;
        }
        return pgpSecKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider((Provider)HsblPgpHelper.getProviderInstance()).build(pass));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PGPSecretKey readSecretKey(InputStream input) throws IOException, PGPException {
        try (InputStream ds = PGPUtil.getDecoderStream((InputStream)input);){
            PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(ds, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            Iterator keyRingIter = pgpSec.getKeyRings();
            block10: while (true) {
                if (!keyRingIter.hasNext()) throw new IllegalArgumentException("Can't find signing key in key ring.");
                PGPSecretKeyRing keyRing = (PGPSecretKeyRing)keyRingIter.next();
                Iterator keyIter = keyRing.getSecretKeys();
                while (true) {
                    if (!keyIter.hasNext()) continue block10;
                    PGPSecretKey key = (PGPSecretKey)keyIter.next();
                    if (key.isSigningKey()) {
                        PGPSecretKey pGPSecretKey = key;
                        return pGPSecretKey;
                    }
                    continue;
                    break;
                }
                break;
            }
        }
    }
}

