/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.api.detail;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbl.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbl.dc.HsblMetaDataImpl;
import kd.ebg.aqap.banks.hsbl.dc.service.api.HsblPgpHelper;
import kd.ebg.aqap.banks.hsbl.dc.service.utils.HSBL_DC_Utils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.HttpsConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.TcpConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public boolean match(BankDetailRequest request) {
        return BankBusinessConfig.getDetailMethod().equalsIgnoreCase("API");
    }

    public EBBankDetailResponse doBiz(BankDetailRequest rqst) {
        ArrayList detailList = new ArrayList(16);
        LocalDate startDate = rqst.getStartDate();
        LocalDate endDate = rqst.getEndDate();
        while (!startDate.isAfter(endDate)) {
            this.setLastPage(false);
            rqst.setStartDate(startDate);
            try {
                do {
                    logger.info("\u524d\u7f6e\u673a\u4ea4\u4e92\u6d41\u7a0b\u5f00\u59cb");
                    String rqstStr = this.pack(rqst);
                    logger.info("\u5c01\u88c5\u6570\u636e\u5b8c\u6210");
                    super.setDetailImpl();
                    ConnectionFactory factory = this.getConnectionFactory();
                    logger.info("\u521b\u5efa\u8fde\u63a5\u5de5\u5382\u5b8c\u6210");
                    IConnection conn = this.getConnection(factory);
                    logger.info("\u6784\u9020\u8fde\u63a5\u5b8c\u6210");
                    this.openConnection(conn);
                    logger.info("\u6253\u5f00\u8fde\u63a5\u5b8c\u6210");
                    try (OutputStream os = this.getOutputStream(conn);){
                        logger.info("\u83b7\u53d6\u8f93\u51fa\u6d41\u5b8c\u6210");
                        this.send(os, rqstStr);
                        logger.info("\u53d1\u9001\u6570\u636e\u5b8c\u6210");
                        this.closeOutputStreamQuietly(os);
                        logger.info("\u5173\u95ed\u8f93\u51fa\u6d41\u5b8c\u6210");
                        try (InputStream is = this.getInputStream(conn);){
                            logger.info("\u83b7\u53d6\u8f93\u5165\u6d41\u5b8c\u6210");
                            String rspStr = this.recv(is);
                            logger.info("\u63a5\u6536\u6570\u636e\u5b8c\u6210");
                            this.closeInputStreamQuietly(is);
                            logger.info("\u5173\u95ed\u8f93\u5165\u6d41\u5b8c\u6210");
                            HttpsConnection connChanged = (HttpsConnection)conn;
                            String token = connChanged.getHttpsHeaderField("x-batch-token");
                            RequestContextUtils.setRunningParam((String)"x-batch-token", (String)token);
                            EBBankDetailResponse response = this.parse(rqst, rspStr);
                            detailList.addAll(response.getDetails());
                        }
                    }
                } while (!this.isLastPage());
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            startDate = startDate.plusDays(1L);
        }
        return new EBBankDetailResponse(detailList);
    }

    public IConnection getConnection(ConnectionFactory factory) {
        HashMap<String, String> httpHeaders = new HashMap<String, String>(16);
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("x-hsbc-client-id", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.clientId));
        httpHeaders.put("x-hsbc-client-secret", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.clientSecret));
        httpHeaders.put("x-hsbc-profile-id", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.profileId));
        httpHeaders.put("x-report-type", "CAMT");
        String token = RequestContextUtils.getRunningParam((String)"x-batch-token");
        if (!StringUtils.isEmpty((String)token)) {
            httpHeaders.put("x-batch-token", token);
        }
        String ip = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiIP);
        String port = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiPort);
        String protocol = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiProtocol);
        String uri = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.detailURI);
        String timeOut = RequestContextUtils.getBankParameterValue((String)"timeout");
        if ("http".equalsIgnoreCase(protocol)) {
            return new HttpConnection(ip, Integer.parseInt(port), uri, httpHeaders, Integer.parseInt(timeOut));
        }
        if ("tcp".equalsIgnoreCase(protocol)) {
            return new TcpConnection(ip, Integer.parseInt(port), Integer.parseInt(timeOut));
        }
        if ("https".equalsIgnoreCase(protocol)) {
            return new HttpsConnection(ip, Integer.parseInt(port), uri, httpHeaders, Integer.parseInt(timeOut));
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5176\u4ed6\u901a\u8baf\u534f\u8bae\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
    }

    public String getDeveloper() {
        return "guoqiangyao";
    }

    public String getBizCode() {
        return "DETAIL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6052\u751f\u94f6\u884cAPI\u660e\u7ec6\u63a5\u53e3", (String)"DetailImpl_1", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]);
    }

    public String pack(BankDetailRequest rqst) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());
        JSONObject detail = new JSONObject();
        String country = rqst.getAcnt().getCountry();
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(country);
        if (null == code) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56fd\u5bb6\u7801\uff1a%s\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"DetailImpl_23", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), country));
        }
        detail.put("accountNumber", (Object)rqst.getAcnt().getAccNo());
        detail.put("accountCountry", (Object)code.geteChart2());
        detail.put("institutionCode", (Object)RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.institutionCode));
        detail.put("accountType", (Object)"CA");
        detail.put("transactionDate", (Object)DateUtil.formatDate((LocalDate)rqst.getStartDate(), (String)"yyyy-MM-dd"));
        try {
            String base64 = HsblPgpHelper.encry(detail.toJSONString());
            JSONObject request = new JSONObject();
            request.put("transactionsRequestBase64", (Object)base64);
            logger.infoFilerLog("\u53d1\u9001\u94f6\u884c:" + request.toJSONString());
            return request.toJSONString();
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"DetailImpl_24", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String rspStr) {
        Element GrpHdr;
        Element MsgPgntn;
        String LastPgInd;
        String origin;
        this.setLastPage(true);
        logger.infoFilerLog("\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
        JSONObject accountBalances = JSONObject.parseObject((String)rspStr);
        String statusCode = accountBalances.getString("statusCode");
        String statusDesc = accountBalances.getString("statusDesc");
        if (!"ACCP".equals(statusCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,%1$s,%2$s", (String)"DetailImpl_25", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), statusCode, statusDesc));
        }
        String base64 = accountBalances.getString("reportBase64");
        try {
            origin = HsblPgpHelper.decry(base64);
            logger.info("\u89e3\u5bc6\u9a8c\u7b7e\u540e\u7684\u539f\u6587:" + origin);
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"DetailImpl_26", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        Document document = JDomUtils.str2Doc((String)origin, (String)"UTF-8");
        Element root = document.getRootElement();
        Namespace ns = root.getNamespace();
        String uri = ns.getURI();
        Element BkToCstmrStmt = HSBL_DC_Utils.getElementNotNull(root, "BkToCstmrStmt", ns);
        if (BkToCstmrStmt == null) {
            ns = null;
            BkToCstmrStmt = HSBL_DC_Utils.getElementNotNull(root, "BkToCstmrAcctRpt", ns);
        }
        if ("false".equalsIgnoreCase(LastPgInd = HSBL_DC_Utils.getChildText(MsgPgntn = HSBL_DC_Utils.getElementNotNull(GrpHdr = HSBL_DC_Utils.getElementNotNull(BkToCstmrStmt, "GrpHdr", ns), "MsgPgntn", ns), "LastPgInd", ns))) {
            this.setLastPage(false);
        }
        Element Stmt = null;
        if (uri.contains("camt.053")) {
            Stmt = HSBL_DC_Utils.getElementNotNull(BkToCstmrStmt, "Stmt", ns);
        } else if (uri.contains("camt.052")) {
            Stmt = HSBL_DC_Utils.getElementNotNull(BkToCstmrStmt, "Rpt", ns);
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u7a7a\u95f4\u540d:%s\u3002", (String)"DetailImpl_27", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), uri));
        }
        BankAcnt acnt = rqst.getAcnt();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        List list = Stmt.getChildren("Ntry", ns);
        if (list.isEmpty()) {
            return new EBBankDetailResponse(detailList);
        }
        for (Element Ntry : list) {
            DetailInfo info = new DetailInfo();
            info.setAccNo(acnt.getAccNo());
            info.setAccName(acnt.getAccName());
            info.setBankName(acnt.getBankName());
            Element Amt = HSBL_DC_Utils.getElementNotNull(Ntry, "Amt", ns);
            String amount = HSBL_DC_Utils.getChildText(Ntry, "Amt", ns);
            info.setCurrency(Amt.getAttributeValue("Ccy"));
            String cdFlag = HSBL_DC_Utils.getChildText(Ntry, "CdtDbtInd", ns);
            if ("DBIT".equals(cdFlag)) {
                info.setDebitAmount(new BigDecimal(amount));
                info.setCreditAmount(BigDecimal.ZERO);
            } else if ("CRDT".equals(cdFlag)) {
                info.setDebitAmount(BigDecimal.ZERO);
                info.setCreditAmount(new BigDecimal(amount));
            }
            Element ValDt = HSBL_DC_Utils.getElementNotNull(Ntry, "ValDt", ns);
            String vt = HSBL_DC_Utils.getChildText(ValDt, "Dt", ns);
            LocalDate date = LocalDate.parse(vt, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            info.setTransDate(date);
            LocalDateTime dateTime = LocalDateTime.parse(vt + "000000", DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss"));
            info.setTransTime(dateTime);
            String AddtlNtryInf = HSBL_DC_Utils.getChildText(Ntry, "AddtlNtryInf", ns);
            info.setExplanation(AddtlNtryInf);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("accNo", (Object)acnt.getAccNo());
            info.setJsonMap(jsonObject.toJSONString());
            detailList.add(info);
        }
        return new EBBankDetailResponse(detailList);
    }
}

