/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.api.payment.single;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.ebg.aqap.banks.hsbl.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbl.dc.HsblMetaDataImpl;
import kd.ebg.aqap.banks.hsbl.dc.service.utils.Helper;
import kd.ebg.aqap.banks.hsbl.dc.service.utils.TransactionRemarksUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PayPacker {
    public static Element packPayXmlhead(PaymentInfo[] paymentInfos, Element CstmrCdtTrfInitn, Namespace ns) throws EBServiceException {
        PaymentInfo paymentInfo = paymentInfos[0];
        Element GrpHdr = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"GrpHdr").setNamespace(ns);
        JDomUtils.addChild((Element)GrpHdr, (String)"MsgId", (String)paymentInfo.getBatchSeqId()).setNamespace(ns);
        JDomUtils.addChild((Element)GrpHdr, (String)"CreDtTm", (String)PayPacker.now()).setNamespace(ns);
        String payProtocol = BankBusinessConfig.getPayProtocol();
        if (!StringUtils.isEmpty((String)payProtocol)) {
            Element Authstn = JDomUtils.addChild((Element)GrpHdr, (String)"Authstn").setNamespace(ns);
            JDomUtils.addChild((Element)Authstn, (String)"Cd", (String)payProtocol).setNamespace(ns);
        }
        Element NbOfTxs = JDomUtils.addChild((Element)GrpHdr, (String)"NbOfTxs").setNamespace(ns);
        NbOfTxs.addContent(String.valueOf(paymentInfos.length));
        Element InitgPty = JDomUtils.addChild((Element)GrpHdr, (String)"InitgPty").setNamespace(ns);
        Element Id = JDomUtils.addChild((Element)InitgPty, (String)"Id").setNamespace(ns);
        Element OrgId = JDomUtils.addChild((Element)Id, (String)"OrgId").setNamespace(ns);
        Element Othr = JDomUtils.addChild((Element)OrgId, (String)"Othr").setNamespace(ns);
        JDomUtils.addChild((Element)Othr, (String)"Id", (String)RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.connectCustomerID)).setNamespace(ns);
        return GrpHdr;
    }

    public static Element packPayXmlPmtInfo(PaymentInfo[] paymentInfos, Element CstmrCdtTrfInitn, Namespace ns) throws EBServiceException {
        PaymentInfo paymentInfo = paymentInfos[0];
        String accNo = paymentInfo.getAccNo();
        LocalDateTime bookDate = paymentInfo.getBookingTime();
        Element PmtInf = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"PmtInf").setNamespace(ns);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtInfId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtMtd", (String)"TRF").setNamespace(ns);
        Element PmtTpInf = JDomUtils.addChild((Element)PmtInf, (String)"PmtTpInf").setNamespace(ns);
        Element SvcLvl = JDomUtils.addChild((Element)PmtTpInf, (String)"SvcLvl").setNamespace(ns);
        JDomUtils.addChild((Element)SvcLvl, (String)"Cd", (String)"URGP").setNamespace(ns);
        Element Lcllnstrm = JDomUtils.addChild((Element)PmtTpInf, (String)"LclInstrm").setNamespace(ns);
        JDomUtils.addChild((Element)Lcllnstrm, (String)"Prtry", (String)"CNAPS").setNamespace(ns);
        if (paymentInfo.getBookingTime() != null && paymentInfo.getBookingTime().isAfter(LocalDateTime.now())) {
            JDomUtils.addChild((Element)PmtInf, (String)"ReqdExctnDt", (String)DateTimeUtils.format((Date)Date.from(bookDate.atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyy-MM-dd")).setNamespace(ns);
            PaymentUtil.setBookPayFlag((PaymentInfo[])paymentInfos);
        } else {
            JDomUtils.addChild((Element)PmtInf, (String)"ReqdExctnDt", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).setNamespace(ns);
        }
        Element Dbtr = JDomUtils.addChild((Element)PmtInf, (String)"Dbtr").setNamespace(ns);
        JDomUtils.addChild((Element)Dbtr, (String)"Nm", (String)BankBusinessConfig.getPayCompanyName(accNo)).setNamespace(ns);
        Element DbtrAcct = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAcct").setNamespace(ns);
        Element DbtrAcct_Id = JDomUtils.addChild((Element)DbtrAcct, (String)"Id").setNamespace(ns);
        Element DbtrAcct_Othr = JDomUtils.addChild((Element)DbtrAcct_Id, (String)"Othr").setNamespace(ns);
        JDomUtils.addChild((Element)DbtrAcct_Othr, (String)"Id", (String)accNo).setNamespace(ns);
        Element DbtrAgt = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAgt").setNamespace(ns);
        Element FinInstnId = JDomUtils.addChild((Element)DbtrAgt, (String)"FinInstnId").setNamespace(ns);
        JDomUtils.addChild((Element)FinInstnId, (String)"BIC", (String)BankBusinessConfig.getBicCode(accNo)).setNamespace(ns);
        Element FinInstnId_PstlAdr = JDomUtils.addChild((Element)FinInstnId, (String)"PstlAdr").setNamespace(ns);
        JDomUtils.addChild((Element)FinInstnId_PstlAdr, (String)"Ctry", (String)BankBusinessConfig.getBankCity(accNo)).setNamespace(ns);
        return PmtInf;
    }

    public static String packPayXmlPP(PaymentInfo[] paymentInfos) throws EBServiceException {
        Namespace ns = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element root = JDomUtils.createRoot((String)"Document");
        root.setNamespace(ns);
        Element CstmrCdtTrfInitn = JDomUtils.addChild((Element)root, (String)"CstmrCdtTrfInitn").setNamespace(ns);
        PayPacker.packPayXmlhead(paymentInfos, CstmrCdtTrfInitn, ns);
        Element PmtInf = PayPacker.packPayXmlPmtInfo(paymentInfos, CstmrCdtTrfInitn, ns);
        for (PaymentInfo item : paymentInfos) {
            String payerFeeType = PaymentInfoSysFiled.get((PaymentInfo)item, (String)"payerFeeType");
            Element CdtTrfTxInf = JDomUtils.addChild((Element)PmtInf, (String)"CdtTrfTxInf").setNamespace(ns);
            Element PmtId = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"PmtId").setNamespace(ns);
            JDomUtils.addChild((Element)PmtId, (String)"EndToEndId", (String)item.getBankDetailSeqId()).setNamespace(ns);
            Element Amt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Amt").setNamespace(ns);
            Element InstdAmt = JDomUtils.addChild((Element)Amt, (String)"InstdAmt", (String)item.getAmount().toString()).setNamespace(ns);
            InstdAmt.setAttribute("Ccy", item.getCurrency());
            if ("02".equalsIgnoreCase(payerFeeType)) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns);
            } else if ("03".equalsIgnoreCase(payerFeeType)) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns);
            } else {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns);
            }
            Element CdtrAgt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAgt").setNamespace(ns);
            Element CdtrAgt_FinInstnId = JDomUtils.addChild((Element)CdtrAgt, (String)"FinInstnId").setNamespace(ns);
            if (!StringUtils.isEmpty((String)item.getIncomeSwiftCode())) {
                JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"BIC", (String)item.getIncomeSwiftCode()).setNamespace(ns);
            }
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"Nm", (String)item.getIncomeBankName()).setNamespace(ns);
            Element CdtrAgt_FinInstnId_PstlAdr = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"PstlAdr").setNamespace(ns);
            String benefitBankAddress = item.getIncomeBankAddress();
            Helper.addressSplit(CdtrAgt_FinInstnId_PstlAdr, benefitBankAddress);
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId_PstlAdr, (String)"Ctry", (String)"CN").setNamespace(ns);
            Element Cdtr = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Cdtr").setNamespace(ns);
            JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)Helper.formatStringByLength(item.getIncomeAccName(), 70)).setNamespace(ns);
            Element Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns);
            Helper.addressSplit(Cdtr_PstlAdr, item.getIncomeAddress());
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Ctry", (String)"CN").setNamespace(ns);
            Element CdtrAcct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAcct").setNamespace(ns);
            Element CdtrAcct_Id = JDomUtils.addChild((Element)CdtrAcct, (String)"Id").setNamespace(ns);
            Element CdtrAcct_Id_Othr = JDomUtils.addChild((Element)CdtrAcct_Id, (String)"Othr").setNamespace(ns);
            JDomUtils.addChild((Element)CdtrAcct_Id_Othr, (String)"Id", (String)item.getIncomeAccNo()).setNamespace(ns);
            if (!StringUtils.isEmpty((String)item.getTransactionRemarks())) {
                Element RgltryRptg = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RgltryRptg").setNamespace(ns);
                Element Dtls = JDomUtils.addChild((Element)RgltryRptg, (String)"Dtls").setNamespace(ns);
                String Inf = TransactionRemarksUtils.getInstance().getTransactionRemark(item.getTransactionRemarks(), item.getBankVersionID());
                JDomUtils.addChild((Element)Dtls, (String)"Inf", (String)Inf).setNamespace(ns);
            }
            if (StringUtils.isEmpty((String)item.getExplanation())) continue;
            Element RmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RmtInf").setNamespace(ns);
            JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)item.getExplanation()).setNamespace(ns);
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private static String now() {
        return DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss").replace(' ', 'T');
    }
}

