/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.api.payment.single;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbl.dc.service.api.HsblPgpHelper;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PayParser {
    public static void parsePay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(PayParser.class);
        JSONObject payRsp = JSONObject.parseObject((String)rspStr);
        String error = payRsp.getString("error");
        String description = payRsp.getString("description");
        if (!StringUtils.isEmpty((String)error)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PayParser_0", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)error, (String)description);
        } else {
            String statusCode = payRsp.getString("statusCode");
            String statusDesc = payRsp.getString("statusDesc");
            if ("RJCT".equalsIgnoreCase(statusCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PayParser_0", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)statusCode, (String)statusDesc);
            } else {
                String base64 = payRsp.getString("responseBase64");
                try {
                    String origin = HsblPgpHelper.decry(base64);
                    logger.info("\u89e3\u5bc6\u9a8c\u7b7e\u540e\u7684\u539f\u6587:" + origin);
                }
                catch (Throwable e) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"PayParser_5", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                }
                String referenceId = payRsp.getString("referenceId");
                PaymentInfoSysFiled.set(Arrays.asList(paymentInfos), (String)"hsbl_referenceId", (String)referenceId);
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)statusCode, (String)statusDesc);
            }
        }
    }
}

