/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.service.areacode.AreaCodeImpl;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public EBBankBalanceResponse doBiz(BankBalanceRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceRequest rqst) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);
        BankAcnt acnt = rqst.getAcnt();
        String accNo = acnt.getAccNo();
        String branchNo = AreaCodeImpl.getInstance().getAreaCode(acnt);
        JSONObject ntqabinfy = new JSONObject();
        ntqabinfy.put("accnbr", (Object)accNo);
        ntqabinfy.put("bbknbr", (Object)branchNo);
        Date date = Date.from(rqst.getStartDate().atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
        ntqabinfy.put("bgndat", (Object)DateUtil.formatDate((Date)date));
        date = Date.from(rqst.getEndDate().atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
        ntqabinfy.put("enddat", (Object)DateUtil.formatDate((Date)date));
        ntqabinfy.put("ccynbr", (Object)rqst.getBankCurrency());
        JSONObject body = new JSONObject();
        body.put("ntqabinfy", (Object)ntqabinfy);
        String bizCode = "NTQABINF";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);
        String res = MsgParser.getReceMsg(rspStr, logger);
        return this.parse(res, rqst.getBankCurrency(), rqst.getBankAcntList());
    }

    public EBBankBalanceResponse parse(String res, String bankCurrency, List<BankAcnt> bankAcntList) {
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntqacinfz = body.getJSONArray("ntqabinfz");
        BalanceInfo[] balances = new BalanceInfo[ntqacinfz.size()];
        for (int i = 0; i < ntqacinfz.size(); ++i) {
            balances[i] = new BalanceInfo();
            JSONObject detail = ntqacinfz.getJSONObject(i);
            String accnbr = detail.getString("accnbr");
            String balamt = detail.getString("balamt");
            String trsdat = detail.getString("trsdat");
            try {
                Date balanceDate = DateTimeUtils.parseDate((String)trsdat, (String)"yyyyMMdd");
                Instant instant = balanceDate.toInstant();
                ZoneId zoneId = ZoneId.systemDefault();
                LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
                balances[i].setBalanceDateTime(localDateTime);
            }
            catch (Exception e) {
                balances[i].setError(BalanceUtils.wrongDateFormatter());
            }
            this.setCurrentBalance(balances[i], balamt);
            this.setBankAcnt(balances[i], bankAcntList, accnbr);
            this.setBankCurrency(balances[i], bankCurrency);
        }
        ArrayList balanceInfoList = new ArrayList(balances.length);
        Collections.addAll(balanceInfoList, balances);
        return new EBBankBalanceResponse(balanceInfoList);
    }

    public LocalDate limitDate() {
        return LocalDate.of(1970, 1, 1);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "NTQABINF";
    }

    public int queryDays() {
        return 31;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

