/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.balancereconciliation;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceReconciliationImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;

public class BalanceReconciliationImpl
extends AbstractBalanceReconciliationImpl
implements IBalanceReconciliation {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceReconciliationImpl.class);

    public EBBankBalanceReconciliationResponse doBiz(BankBalanceReconciliationRequest request) {
        try {
            String rqstStr = this.pack(request);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(request, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceReconciliationRequest request) {
        BalanceReconciliationDetail detail = request.getDetail();
        JSONArray ntoprmodx = new JSONArray();
        JSONObject ntoprmodx1 = new JSONObject();
        ntoprmodx1.put("busmod", (Object)BankBusinessConfig.getBalanceReconciliationBusMod(request.getDetail().getAccNo()));
        ntoprmodx.add((Object)ntoprmodx1);
        JSONArray ntnstoprx = new JSONArray();
        JSONObject ntnstoprx1 = new JSONObject();
        ntnstoprx.add((Object)ntnstoprx1);
        ntnstoprx1.put("sqrnbr", (Object)Sequence.gen8Sequence());
        ntnstoprx1.put("bchnbr", (Object)detail.getBiz("bchnbr"));
        ntnstoprx1.put("barcod", (Object)detail.getStatementNo());
        ntnstoprx1.put("barseq", (Object)detail.getBiz("barseq"));
        ntnstoprx1.put("eacnbr", (Object)detail.getAccNo());
        ntnstoprx1.put("actseq", (Object)detail.getBiz("actseq"));
        ntnstoprx1.put("accnbr", (Object)detail.getBiz("accnbr"));
        ntnstoprx1.put("yermth", (Object)detail.getMonth());
        ntnstoprx1.put("balflg", (Object)detail.getCheckStatus());
        ntnstoprx1.put("yurref", (Object)Sequence.gen18Sequence());
        ntnstoprx1.put("adjcas", (Object)"00000");
        ntnstoprx1.put("telnbr", (Object)"");
        ntnstoprx1.put("logtxt", (Object)"");
        JSONObject body = new JSONObject();
        body.put("ntoprmodx", (Object)ntoprmodx);
        body.put("ntnstoprx", (Object)ntnstoprx);
        String bizCode = this.getBizCode();
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.gen18Sequence());
        JSONObject req = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(req, this.logger, bizCode);
    }

    public EBBankBalanceReconciliationResponse parse(BankBalanceReconciliationRequest bankBalanceReconciliationRequest, String s) {
        BalanceReconciliationDetail detail = bankBalanceReconciliationRequest.getDetail();
        String res = MsgParser.getReceMsg(s, this.logger);
        BankResponse response = MsgParser.getResponse(res, this.logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"BalanceReconciliationImpl_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject root = JSONObject.parseObject((String)res);
        JSONObject resp = root.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntoprrtnz = body.getJSONArray("ntoprrtnz");
        if (ntoprrtnz == null || ntoprrtnz.size() == 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56dentoprrtnz\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"BalanceReconciliationImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        JSONObject jsonObject = ntoprrtnz.getJSONObject(0);
        String reqSts = jsonObject.getString("reqsts");
        String rtnFlg = jsonObject.getString("rtnflg");
        detail.setSys("reqnbr", jsonObject.getString("reqnbr"));
        if ("FIN".equalsIgnoreCase(reqSts) && "F".equalsIgnoreCase(rtnFlg)) {
            String errCod = jsonObject.getString("errcod");
            String errTxt = jsonObject.getString("errtxt");
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.FAIL, (String)errCod, (String)errTxt);
        } else {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUBMITED, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankBalanceReconciliationResponse(detail);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "NTNSTOPR";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u53cd\u9988\u4f59\u989d\u5bf9\u8d26", (String)"BalanceReconciliationImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceReconciliationRequest request) {
        return true;
    }
}

