/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.curandfixed.cur2fixed;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.areacode.AreaCodeImpl;
import kd.ebg.aqap.banks.cmb.opa.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class CurAndFixedImpl
extends AbstractCAFImpl
implements ICurAndFixed {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CurAndFixedImpl.class);

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        String bizCode = "SDKNTCTFOPR";
        BankAcnt acnt = bankCurAndFixedRequest.getHeader().getAcnt();
        logger.info("----------------------xxxxxxxxx------------>" + acnt.getAreaCode());
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        JSONObject ntctfoprx = new JSONObject();
        String busmod = BankBusinessConfig.getCurAndFixedBusMod(acnt.getAccNo());
        ntctfoprx.put("buscod", (Object)"N08010");
        ntctfoprx.put("busmod", (Object)busmod);
        String areaCode = AreaCodeImpl.getInstance().getAreaCode(acnt);
        ntctfoprx.put("bbknbr", (Object)areaCode);
        ntctfoprx.put("accnbr", (Object)curAndFixedInfo.getAccNo());
        ntctfoprx.put("ccynbr", (Object)curAndFixedInfo.getCurrency());
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal add = amount.add(new BigDecimal(curAndFixedInfo.getAmount()));
        if (add.compareTo(new BigDecimal("10000")) < 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"<Check>\u6d3b\u671f\u8f6c\u4e3a\u5b9a\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e10000</Check>\u3002", (String)"CurAndFixedImpl_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        ntctfoprx.put("trsamt", (Object)curAndFixedInfo.getAmount());
        if (curAndFixedInfo.getDepositTermValue() == null || "1".equals(curAndFixedInfo.getDepositTermValue())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"<Check>\u5b58\u671f\u4e3a\u7a7a\u6216\u4e0d\u652f\u6301\u7684\u5b58\u671f\uff0c\u5f53\u524d\u62db\u884c\u652f\u6301\u7684\u5b58\u671f\u4e3a3 6 12 24 36 48 60</Check>\u3002", (String)"CurAndFixedImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        if (curAndFixedInfo.getDepositTermValue().trim().length() == 2) {
            ntctfoprx.put("terdum", (Object)("0" + curAndFixedInfo.getDepositTermValue()));
        } else {
            ntctfoprx.put("terdum", (Object)("00" + curAndFixedInfo.getDepositTermValue()));
        }
        ntctfoprx.put("yurref", (Object)PaymentUtil.addKDFlag(bankCurAndFixedRequest.getBatchSeqId()));
        JSONArray array = new JSONArray();
        array.add((Object)ntctfoprx);
        JSONObject body = new JSONObject();
        body.put("ntctfoprx", (Object)array);
        JSONObject request = JsonUtil.getrequest(head, body);
        if (EBContext.getContext().isUnitTest()) {
            return "";
        }
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public EBBankCurAndFixedResponse doBiz(BankCurAndFixedRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        String res = MsgParser.getReceMsg(s, logger);
        return this.parse(res, bankCurAndFixedRequest);
    }

    public EBBankCurAndFixedResponse parse(String res, BankCurAndFixedRequest bankCurAndFixedRequest) {
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        List details = bankCurAndFixedRequest.getCafInfos();
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a<Check>%s</Check>\u3002", (String)"CurAndFixedImpl_10", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntctfoprz = body.getJSONArray("ntctfoprz");
        if (ntctfoprz.size() <= 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u8fc7\u7a0b\u4e2d\u94f6\u884c\u8fd4\u56de\u4e86\u7a7a\u6570\u636e\u3002", (String)"CurAndFixedImpl_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)details.get(0);
        JSONObject detail = ntctfoprz.getJSONObject(0);
        String bbknbr = detail.getString("bbknbr");
        String accnbr = detail.getString("accnbr");
        String intdat = detail.getString("intdat");
        String expdat = detail.getString("expdat");
        String reqnbr = detail.getString("reqnbr");
        curAndFixedInfo.setFixedAcntBankNo(bbknbr);
        curAndFixedInfo.setFixedAcntBank(accnbr);
        curAndFixedInfo.setRateDate(intdat);
        curAndFixedInfo.setEndDate(expdat);
        curAndFixedInfo.setEndIntDate(expdat);
        curAndFixedInfo.setReqNbr(reqnbr);
        CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CurAndFixedImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)"", (String)"");
        ebBankCurAndFixedResponse.setDetails(details);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "SDKNTCTFOPR";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b9a\u671f\u8f6c\u6d3b\u671f", (String)"CurAndFixedImpl_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public int getBatchSize() {
        return 0;
    }
}

