/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.curandfixed.fixed2cur;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.areacode.AreaCodeImpl;
import kd.ebg.aqap.banks.cmb.opa.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class CurAndFixedImpl
extends AbstractCAFImpl
implements ICurAndFixed {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CurAndFixedImpl.class);

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        String bizCode = "NTFTCOPR";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        BankAcnt acnt = bankCurAndFixedRequest.getHeader().getAcnt();
        JSONObject ntftcoprx = new JSONObject();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)bankCurAndFixedRequest.getCafInfos().get(0);
        String busmod = BankBusinessConfig.getCurAndFixedBusMod(acnt.getAccNo());
        ntftcoprx.put("buscod", (Object)"N08010");
        ntftcoprx.put("busmod", (Object)busmod);
        String areaCode = AreaCodeImpl.getInstance().getAreaCode(acnt);
        ntftcoprx.put("bbknbr", (Object)areaCode);
        ntftcoprx.put("accnbr", (Object)curAndFixedInfo.getAccNo());
        ntftcoprx.put("fixbbk", (Object)areaCode);
        ntftcoprx.put("fixacc", (Object)curAndFixedInfo.getFixedAccNo());
        ntftcoprx.put("ccynbr", (Object)curAndFixedInfo.getCurrency());
        BigDecimal amount = BigDecimal.ZERO;
        amount = amount.add(new BigDecimal(curAndFixedInfo.getAmount()));
        if (amount.compareTo(new BigDecimal("10000")) < 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"<Check>\u5b9a\u671f\u5b58\u6b3e\u8f6c\u4e3a\u6d3b\u671f\u72b6\u6001\u5e94\u5927\u4e8e\u7b49\u4e8e10000</Check>\u3002", (String)"CurAndFixedImpl_6", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        ntftcoprx.put("trsamt", (Object)curAndFixedInfo.getAmount());
        ntftcoprx.put("yurref", (Object)PaymentUtil.addKDFlag(bankCurAndFixedRequest.getBatchSeqId()));
        JSONArray array = new JSONArray();
        array.add((Object)ntftcoprx);
        JSONObject body = new JSONObject();
        body.put("ntftcoprx", (Object)array);
        JSONObject request = JsonUtil.getrequest(head, body);
        logger.info("\u5373\u5c06\u53d1\u9001\u7684\u62a5\u6587>>>>>>>>>>>>>>>>>>>{}", (Object)request.toJSONString());
        if (EBContext.getContext().isUnitTest()) {
            return "";
        }
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public EBBankCurAndFixedResponse doBiz(BankCurAndFixedRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        String res = MsgParser.getReceMsg(s, logger);
        return this.parse(res, bankCurAndFixedRequest);
    }

    public EBBankCurAndFixedResponse parse(String res, BankCurAndFixedRequest bankCurAndFixedRequest) {
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"CurAndFixedImpl_11", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntctfoprz = body.getJSONArray("ntftcoprz");
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        if (ntctfoprz.size() <= 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u8fc7\u7a0b\u4e2d\u94f6\u884c\u8fd4\u56de\u4e86\u7a7a\u6570\u636e\u3002", (String)"CurAndFixedImpl_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        JSONObject detail = ntctfoprz.getJSONObject(0);
        String terdum = detail.getString("terdum");
        String intdat = detail.getString("intdat");
        String expdat = detail.getString("expdat");
        String eindat = detail.getString("eindat");
        String actbal = detail.getString("actbal");
        String trsamt = detail.getString("trsamt");
        String intamt = detail.getString("intamt");
        String taxamt = detail.getString("taxamt");
        String feeccy = detail.getString("feeccy");
        String feeamt = detail.getString("feeamt");
        String reqnbr = detail.getString("reqnbr");
        String rsv50z = detail.getString("rsv50z");
        curAndFixedInfo.setDepositTermValue(terdum);
        curAndFixedInfo.setRateDate(intdat);
        curAndFixedInfo.setEndDate(expdat);
        curAndFixedInfo.setEndIntDate(eindat);
        curAndFixedInfo.setAccBal(actbal);
        curAndFixedInfo.setFixActInt(intamt);
        curAndFixedInfo.setFixTaxInt(taxamt);
        curAndFixedInfo.setReqNbr(reqnbr);
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public int getBatchSize() {
        return 0;
    }
}

