/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.areacode.AreaCodeImpl;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.balance.BalanceMethod;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceMethod.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        return this.detailWithPage(request);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        LocalDate temp = LocalDate.from(request.getStartDate());
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(1);
        while (temp.isBefore(request.getEndDate()) || temp.isEqual(request.getEndDate())) {
            dates.add(temp);
            temp = temp.plusDays(1L);
        }
        ArrayList detailInfos = new ArrayList(1);
        for (LocalDate date : dates) {
            request.setStartDate(date);
            EBBankDetailResponse response = this.detailWithPage(request);
            detailInfos.addAll(response.getDetails());
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse doBiz(BankDetailRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            super.setDetailImpl();
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankDetailRequest request) {
        BankAcnt acnt = request.getHeader().getAcnt();
        String accNo = acnt.getAccNo();
        String branchNo = AreaCodeImpl.getInstance().getAreaCode(acnt);
        JSONObject ntqabinfy = new JSONObject();
        ntqabinfy.put("accnbr", (Object)accNo);
        ntqabinfy.put("bbknbr", (Object)branchNo);
        ntqabinfy.put("trsseq", (Object)this.getCurrentPage());
        ntqabinfy.put("trsdat", (Object)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String bizCode = "DCTRSINF";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.gen18Sequence());
        JSONObject req = JsonUtil.getrequest(head, ntqabinfy);
        return MsgPacker.getSendMsg(req, logger, bizCode);
    }

    private EBBankDetailResponse detailWithPage(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        this.setCurrentPage("0");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            detailInfos.addAll(detailResponse.getDetails());
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse parse(BankDetailRequest req, String rspStr) {
        rspStr = MsgParser.getReceMsg(rspStr, logger);
        return this.parseResult(req, rspStr);
    }

    public EBBankDetailResponse parseResult(BankDetailRequest req, String rspStr) {
        BankResponse response = MsgParser.getResponse(rspStr, logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        String nextPageTag = this.getNextPageTage(rspStr);
        this.setLastPage(this.isLastPage(nextPageTag));
        this.setCurrentPage(nextPageTag);
        JSONObject request = JSONObject.parseObject((String)rspStr);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntqacinfz = body.getJSONArray("ntqactrsz2");
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        if (ntqacinfz == null || ntqacinfz.size() == 0) {
            return new EBBankDetailResponse(detailList);
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < ntqacinfz.size(); ++i) {
            JSONObject obiect = ntqacinfz.getJSONObject(i);
            String etydat = obiect.getString("etydat");
            String etytim = obiect.getString("etytim");
            String explanation1 = obiect.getString("naryur");
            String trsamt = obiect.getString("trsamt");
            String amtcdr = obiect.getString("amtcdr");
            String trsblv = obiect.getString("trsblv");
            String nusage = obiect.getString("nusage");
            String explanation2 = obiect.getString("busnar");
            String oppAccName = obiect.getString("rpynam");
            String oppAccNo = obiect.getString("rpyacc");
            String rpybbn = obiect.getString("rpybbn");
            String oppAccBank = obiect.getString("rpybnk");
            String groupAccNo = obiect.getString("gsbacc");
            String groupAccName = obiect.getString("gsbnam");
            String yurref = obiect.getString("yurref");
            String refnbr = obiect.getString("refnbr");
            String trscod = obiect.getString("trscod");
            String frmcod = obiect.getString("frmcod");
            DetailInfo detail = new DetailInfo();
            detail.setFrmcod(frmcod);
            detail.setCurrency(req.getHeader().getBankCurrency());
            if ("D".equalsIgnoreCase(amtcdr)) {
                detail.setDebitAmount(new BigDecimal(trsamt).abs());
                detail.setCreditAmount(ParserUtils.ZERO);
            } else if ("C".equalsIgnoreCase(amtcdr)) {
                detail.setCreditAmount(new BigDecimal(trsamt).abs());
                detail.setDebitAmount(ParserUtils.ZERO);
            } else {
                logger.info("\u501f\u8d37\u6807\u8bc6\u5f02\u5e38{}\u3002", (Object)amtcdr);
                continue;
            }
            if (StringUtils.isEmpty((String)groupAccNo)) {
                detail.setOppAccNo(oppAccNo);
                detail.setOppAccName(oppAccName);
                detail.setOppBankName(oppAccBank);
            } else {
                detail.setOppAccNo(groupAccNo);
                detail.setOppAccName(groupAccName);
                detail.setOppBankName("");
            }
            boolean isAutoTransDown = false;
            if ("CSTD".equalsIgnoreCase(trscod)) {
                detail.setTransType("autotransup");
            } else if ("CSTC".equalsIgnoreCase(trscod)) {
                detail.setTransType("autotransdown");
            } else if ("CSTP".equalsIgnoreCase(trscod)) {
                if ("true".equalsIgnoreCase(BankBusinessConfig.isParent(req.getAcnt().getAccNo()))) {
                    if ("D".equalsIgnoreCase(amtcdr)) {
                        detail.setTransType("autotransdown");
                        String toMatchExp = PropertiesConstants.getValue((String)"CMB_OPA_AUTO_TRANS_DOWN_EXP");
                        if (StringUtils.isNotEmpty((String)toMatchExp)) {
                            isAutoTransDown = toMatchExp.equals(explanation1);
                        }
                    } else if ("C".equalsIgnoreCase(amtcdr)) {
                        detail.setTransType("autotransup");
                    }
                } else if ("D".equalsIgnoreCase(amtcdr)) {
                    detail.setTransType("autotransup");
                } else if ("C".equalsIgnoreCase(amtcdr)) {
                    detail.setTransType("autotransdown");
                }
            } else if ("CPAB".equalsIgnoreCase(trscod) || "CPAJ".equalsIgnoreCase(trscod) || "AGRD".equalsIgnoreCase(trscod)) {
                detail.setTransType("refund");
            }
            if (yurref != null && yurref.indexOf("KD_") != -1) {
                yurref = yurref.replaceAll("KINGDEE", "");
                String bankDetailSeqId = yurref.substring("KD_".length());
                if (!isAutoTransDown) {
                    detail.setPayBankDetailSeqID(bankDetailSeqId);
                }
            }
            detail.setBizRefNo(refnbr);
            detail.setBankDetailNo(refnbr);
            LocalDateTime transTime = null;
            if (StringUtils.isEmpty((String)etydat)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a", (String)"DetailImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
            }
            try {
                transTime = StringUtils.isEmpty((String)etytim) ? LocalDateTime.parse(etydat + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) : LocalDateTime.parse(etydat + etytim, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u8f6c\u6362\u5f02\u5e38%s\u3002", (String)"DetailImpl_6", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            detail.setTransTime(transTime);
            detail.setTransDate(LocalDate.parse(etydat, DateTimeFormatter.BASIC_ISO_DATE));
            if (!StringUtils.isEmpty((String)trsblv)) {
                detail.setBalance(new BigDecimal(trsblv));
            }
            String explanation = "";
            explanation = StringUtils.equals((String)explanation2, (String)explanation1) ? explanation2 : StringUtils.catWithSpace((String[])new String[]{explanation2, explanation1});
            detail.setExplanation(explanation);
            detail.setUseCn(nusage);
            String jsonStr = obiect.toJSONString();
            detail.setJsonMap(jsonStr);
            String accNo = req.getHeader().getAcnt().getAccNo();
            String transDate = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detailList.add(detail);
        }
        logger.info("\u89e3\u6790\u5230\u7684\u660e\u7ec6\u6570\u91cf\u4e3a\uff1a" + detailList.size());
        return new EBBankDetailResponse(detailList);
    }

    private String getNextPageTage(String rspStr) {
        JSONObject request = JSONObject.parseObject((String)rspStr);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntrbptrsz1 = body.getJSONArray("ntrbptrsz1");
        JSONObject first = (JSONObject)ntrbptrsz1.get(0);
        String cotflg = first.getString("cotflg");
        String trsseq = first.getString("trsseq");
        if ("Y".equalsIgnoreCase(cotflg)) {
            Integer a = Integer.parseInt(trsseq) + 1;
            return a.toString();
        }
        return cotflg;
    }

    private boolean isLastPage(String pageTag) {
        return "N".equalsIgnoreCase(pageTag);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "DCTRSINF";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"5.1.7\u8d26\u6237\u4ea4\u6613\u4fe1\u606f\u67e5\u8be2(DCTRSINF)", (String)"DetailImpl_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean match(BankDetailRequest request) {
        String accNoType = BankPropertyConfig.getAccNoType((String)request.getAcnt().getAccNo());
        return "normal".equalsIgnoreCase(accNoType) && BankBusinessConfig.isChooseDcTrsInf();
    }
}

