/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.detail.cashpool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.opa.service.areacode.AreaCodeImpl;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class NTMTLTRS
extends AbstractDetailImpl
implements IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(NTMTLTRS.class);

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        LocalDate endDate = request.getEndDate();
        ArrayList detailInfos = new ArrayList(16);
        while (!request.getStartDate().isAfter(endDate)) {
            LocalDate temp = request.getStartDate().plusDays(6L);
            if (temp.isAfter(endDate)) {
                temp = endDate;
            }
            request.setEndDate(temp);
            EBBankDetailResponse response = this.detailWithPage(request);
            detailInfos.addAll(response.getDetails());
            request.setStartDate(temp.plusDays(1L));
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String pack(BankDetailRequest request) {
        BankAcnt acnt = request.getHeader().getAcnt();
        String branchNo = AreaCodeImpl.getInstance().getAreaCode(acnt);
        String accNo = acnt.getAccNo();
        JSONObject body = new JSONObject();
        JSONArray ntmtldthy = new JSONArray();
        body.put("ntmtldthy1", (Object)ntmtldthy);
        JSONObject item = new JSONObject();
        ntmtldthy.add((Object)item);
        item.put("bbknbr", (Object)branchNo);
        item.put("eacnbr", (Object)accNo);
        item.put("trxtyp", (Object)"3");
        item.put("qrymod", (Object)"1");
        item.put("begdat", (Object)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        item.put("enddat", (Object)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        String xc = RequestContextUtils.getRunningParam((String)"xc");
        if (!StringUtils.isEmpty((String)xc)) {
            JSONObject xcObject = JSON.parseObject((String)xc);
            item.put("ctnkey", (Object)MsgPacker.string(xcObject.getString("ctnkey")));
            item.put("lstnbl", (Object)MsgPacker.string(xcObject.getString("lstnbl")));
            item.put("lstdat", (Object)MsgPacker.string(xcObject.getString("lstdat")));
            item.put("nmlflg", (Object)MsgPacker.string(xcObject.getString("nmlflg")));
        }
        JSONObject head = JsonUtil.getHead(this.getBizCode(), Sequence.gen18Sequence());
        JSONObject req = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(req, logger, this.getBizCode());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        s = MsgParser.getReceMsg(s, logger);
        BankResponse response = MsgParser.getResponse(s, logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)s);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(8);
        JSONArray ntmtldtsz1 = body.getJSONArray("ntmtldtsz1");
        if (ntmtldtsz1 == null || ntmtldtsz1.isEmpty()) {
            return new EBBankDetailResponse(detailList);
        }
        JSONArray ntmtltrdy1 = body.getJSONArray("ntmtldthy1");
        if (ntmtltrdy1 != null && !ntmtltrdy1.isEmpty()) {
            this.setLastPage(false);
            JSONObject xc = ntmtltrdy1.getJSONObject(0);
            RequestContextUtils.setRunningParam((String)"xc", (String)xc.toJSONString());
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < ntmtldtsz1.size(); ++i) {
            LocalDateTime transTime;
            JSONObject info = ntmtldtsz1.getJSONObject(i);
            String ccynbr = info.getString("ccynbr");
            String bokdir = info.getString("bokdir");
            String trsamt = info.getString("trsamt");
            String rpyacc = info.getString("rpyacc");
            String rpynam = info.getString("rpynam");
            String rpybnk = info.getString("rpybnk");
            String trscod = info.getString("trscod");
            String refnbr = info.getString("refnbr");
            String trsdat = info.getString("trsdat");
            String etytim = info.getString("etytim");
            String onlbal = info.getString("onlbal");
            String trxtxt = info.getString("trxtxt");
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(ccynbr);
            if ("D".equalsIgnoreCase(bokdir)) {
                detail.setDebitAmount(new BigDecimal(trsamt).abs());
                detail.setCreditAmount(ParserUtils.ZERO);
            } else if ("C".equalsIgnoreCase(bokdir)) {
                detail.setCreditAmount(new BigDecimal(trsamt).abs());
                detail.setDebitAmount(ParserUtils.ZERO);
            } else {
                logger.info("\u501f\u8d37\u6807\u8bc6\u5f02\u5e38{}\u3002", (Object)bokdir);
                continue;
            }
            detail.setOppAccNo(rpyacc);
            detail.setOppAccName(rpynam);
            detail.setOppBankName(rpybnk);
            if ("CSTD".equalsIgnoreCase(trscod)) {
                detail.setTransType("autotransup");
            } else if ("CSTC".equalsIgnoreCase(trscod)) {
                detail.setTransType("autotransdown");
            } else if ("CSTP".equalsIgnoreCase(trscod)) {
                if ("true".equalsIgnoreCase(BankBusinessConfig.isParent(bankDetailRequest.getAcnt().getAccNo()))) {
                    if ("D".equalsIgnoreCase(bokdir)) {
                        detail.setTransType("autotransdown");
                    } else if ("C".equalsIgnoreCase(bokdir)) {
                        detail.setTransType("autotransup");
                    }
                } else if ("D".equalsIgnoreCase(bokdir)) {
                    detail.setTransType("autotransup");
                } else if ("C".equalsIgnoreCase(bokdir)) {
                    detail.setTransType("autotransdown");
                }
            } else if ("CPAB".equalsIgnoreCase(trscod) || "CPAJ".equalsIgnoreCase(trscod) || "AGRD".equalsIgnoreCase(trscod)) {
                detail.setTransType("refund");
            }
            detail.setBizRefNo(refnbr);
            detail.setBankDetailNo(refnbr);
            if (StringUtils.isEmpty((String)trsdat)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a", (String)"DetailImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
            }
            try {
                transTime = StringUtils.isEmpty((String)etytim) ? LocalDateTime.parse(trsdat + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) : LocalDateTime.parse(trsdat + etytim, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u8f6c\u6362\u5f02\u5e38%s\u3002", (String)"DetailImpl_6", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            detail.setTransTime(transTime);
            detail.setTransDate(transTime.toLocalDate());
            if (!StringUtils.isEmpty((String)onlbal)) {
                detail.setBalance(new BigDecimal(onlbal));
            }
            detail.setExplanation(trxtxt);
            info.put("etydat", (Object)trsdat);
            String jsonStr = info.toJSONString();
            detail.setJsonMap(jsonStr);
            String accNo = bankDetailRequest.getHeader().getAcnt().getAccNo();
            String transDate = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detailList.add(detail);
        }
        logger.info("\u89e3\u6790\u5230\u7684\u660e\u7ec6\u6570\u91cf\u4e3a\uff1a" + detailList.size());
        return new EBBankDetailResponse(detailList);
    }

    public EBBankDetailResponse doBiz(BankDetailRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            super.setDetailImpl();
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private EBBankDetailResponse detailWithPage(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        this.setCurrentPage("0");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            detailInfos.addAll(detailResponse.getDetails());
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "NTMTLTRS";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u591a\u7ea7\u73b0\u91d1\u6c60\u5386\u53f2\u7efc\u5408\u4ea4\u6613\u67e5\u8be2", (String)"NTMTLTRS_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean match(BankDetailRequest request) {
        String accNoType = BankPropertyConfig.getAccNoType((String)request.getAcnt().getAccNo());
        return "aggregators".equalsIgnoreCase(accNoType);
    }
}

