/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.oversea;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.service.payment.oversea.PaymentStateEnum;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryOverseaPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryOverseaPayImpl.class);

    public EBBankPayResponse doBiz(BankPayRequest request) {
        try {
            String rqstStr = this.pack(request);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(request, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        JSONObject body = new JSONObject();
        JSONArray queryRemitDetail = new JSONArray();
        JSONObject queryRemitDetail1 = new JSONObject();
        if (StringUtils.isEmpty((String)paymentInfo.getBankRefID())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u94f6\u884c\u6d41\u6c34\u53f7\u4e3a\u7a7a", (String)"QueryPayParser_16", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        queryRemitDetail1.put("ormLgcId", (Object)paymentInfo.getBankRefID());
        queryRemitDetail.add((Object)queryRemitDetail1);
        body.put("queryRemitDetailRequest", (Object)queryRemitDetail);
        String bizCode = this.getBizCode();
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.gen18Sequence());
        JSONObject req = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(req, this.logger, bizCode);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String res = MsgParser.getReceMsg(s, this.logger);
        BankResponse response = MsgParser.getResponse(res, this.logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38%s\u3002", (String)"QueryPayParser_13", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray queryRemitDetailResponse = body.getJSONArray("queryRemitDetailResponse");
        if (queryRemitDetailResponse != null && queryRemitDetailResponse.size() > 0) {
            JSONObject jsonResponse = queryRemitDetailResponse.getJSONObject(0);
            String code = jsonResponse.getString("code");
            String message = jsonResponse.getString("message");
            if ("0000".equalsIgnoreCase(code)) {
                String ortNbr = jsonResponse.getString("ortNbr");
                String busState = jsonResponse.getString("busState");
                PaymentStateEnum paymentStateEnum = PaymentStateEnum.getEnumByBizCodeAndBusState(this.getBizCode(), busState);
                String bankMsg = paymentStateEnum.getBankMsg();
                PaymentState paymentState = paymentStateEnum.getState();
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)paymentState, (String)paymentState.getCnName(), (String)busState, (String)bankMsg);
                if (StringUtils.isNotEmpty((String)ortNbr)) {
                    paymentInfo.setRemitNo(ortNbr);
                }
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"PayParser_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)code, (String)message);
            }
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "queryRemitDetail";
    }

    public String getBizDesc() {
        return null;
    }
}

