/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.util.MyX509TrustManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.LoggerConnection;
import kd.ebg.egf.common.log.EBGLogger;

public class PostUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PostUtil.class);

    public static String getUrl() {
        String exchangeProtocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        String uri = RequestContextUtils.getBankParameterValue((String)"exchangeUri");
        port = "HTTPS".equalsIgnoreCase(exchangeProtocol) && "443".equalsIgnoreCase(port) ? "" : ":" + port;
        String url = exchangeProtocol + "://" + RequestContextUtils.getBankParameterValue((String)"ip") + port + uri;
        logger.info("\u8bbf\u95ee\u7684\u94f6\u884c\u5730\u5740\uff1a" + url);
        return url;
    }

    public static String sendMsg(String content) throws EBServiceException {
        try {
            return PostUtil.doPostForm(PostUtil.getUrl(), content);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.toString());
        }
    }

    public static String sendMsgForPay(String content) throws EBServiceException {
        try {
            return PostUtil.doPostFormForPay(PostUtil.getUrl(), content);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.toString());
        }
    }

    public static String doPostForm(String httpUrl, String param) throws EBServiceException {
        HttpURLConnection connection = null;
        InputStream is = null;
        OutputStream os = null;
        BufferedReader br = null;
        String result = null;
        try {
            URL url = new URL(httpUrl);
            SSLContext sslcontext = SSLContext.getInstance("SSL", "SunJSSE");
            sslcontext.init(null, new TrustManager[]{new MyX509TrustManager()}, new SecureRandom());
            HostnameVerifier ignoreHostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslsession) {
                    logger.info("WARNING: Hostname is not matched for cert.");
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(ignoreHostnameVerifier);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(60000);
            connection.setInstanceFollowRedirects(true);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            os = connection.getOutputStream();
            os.write(param.getBytes());
            LoggerConnection.writeLogger((String)"request", (String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u62a5\u6587\uff1a%s", (String)"PostUtil_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), ""), (String)param);
            if (connection.getResponseCode() != 200) {
                is = connection.getErrorStream();
                br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                StringBuilder sbf = new StringBuilder();
                String temp = null;
                while ((temp = br.readLine()) != null) {
                    sbf.append(temp);
                    sbf.append("\r\n");
                }
                result = sbf.toString();
                LoggerConnection.writeLogger((String)"response", (String)String.format(ResManager.loadKDString((String)"\u975e\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff1a%s", (String)"PostUtil_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), ""), (String)result);
                EBContext.getContext().setType(null);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u975e\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff1a%s", (String)"PostUtil_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), result));
            }
            is = connection.getInputStream();
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder sbf = new StringBuilder();
            String temp = null;
            while ((temp = br.readLine()) != null) {
                sbf.append(temp);
                sbf.append("\r\n");
            }
            result = sbf.toString();
            LoggerConnection.writeLogger((String)"response", (String)String.format(ResManager.loadKDString((String)"\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff1a%s", (String)"PostUtil_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), ""), (String)result);
            EBContext.getContext().setType(null);
        }
        catch (Exception e) {
            if (e instanceof EBServiceException) {
                throw (EBServiceException)e;
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u4e92\u524d\u5931\u8d25%s\u3002", (String)"PostUtil_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
            }
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    public static String doPostFormForPay(String httpUrl, String param) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(PostUtil.class);
        HttpURLConnection connection = null;
        InputStream is = null;
        OutputStream os = null;
        BufferedReader br = null;
        String result = null;
        try {
            URL url = new URL(httpUrl);
            SSLContext sslcontext = SSLContext.getInstance("SSL", "SunJSSE");
            sslcontext.init(null, new TrustManager[]{new MyX509TrustManager()}, new SecureRandom());
            HostnameVerifier ignoreHostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslsession) {
                    System.out.println("WARNING: Hostname is not matched for cert.");
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(ignoreHostnameVerifier);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(60000);
            connection.setInstanceFollowRedirects(true);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            os = connection.getOutputStream();
            os.write(param.getBytes());
            LoggerConnection.writeLogger((String)"request", (String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u62a5\u6587\uff1a%s", (String)"PostUtil_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), ""), (String)param);
            if (connection.getResponseCode() != 200) {
                is = connection.getErrorStream();
                br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                StringBuilder sbf = new StringBuilder();
                String temp = null;
                while ((temp = br.readLine()) != null) {
                    sbf.append(temp);
                    sbf.append("\r\n");
                }
                result = sbf.toString();
                LoggerConnection.writeLogger((String)"response", (String)String.format(ResManager.loadKDString((String)"\u975e\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff1a%s", (String)"PostUtil_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), ""), (String)result);
                EBContext.getContext().setType(null);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u975e\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff1a%s", (String)"PostUtil_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), result));
            }
            is = connection.getInputStream();
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder sbf = new StringBuilder();
            String temp = null;
            while ((temp = br.readLine()) != null) {
                sbf.append(temp);
                sbf.append("\r\n");
            }
            result = sbf.toString();
            EBContext.getContext().setType(null);
        }
        catch (Exception e) {
            if (e instanceof EBServiceException) {
                throw (EBServiceException)e;
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u4e92\u524d\u5931\u8d25%s\u3002", (String)"PostUtil_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
            }
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.info(e.toString());
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }
}

