/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.ecny.service.balance;

import com.icbc.api.response.MybankEnterprisePayQdcbalResponseV1;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

class BalanceParser {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceParser.class);

    BalanceParser() {
    }

    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, MybankEnterprisePayQdcbalResponseV1 response) {
        if (response.isSuccess()) {
            List responseRds = response.getRd();
            MybankEnterprisePayQdcbalResponseV1.MybankEnterprisePayQdcbalResponseRdV1 rd = (MybankEnterprisePayQdcbalResponseV1.MybankEnterprisePayQdcbalResponseRdV1)responseRds.get(0);
            String code = rd.getiRetCode();
            String msg = rd.getiRetMsg();
            if (!"0".equals(code + "")) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 \u3002\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"BalanceParser_0", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]), code, msg));
            }
            BalanceInfo info = new BalanceInfo();
            info.setBankCurrency(rd.getCurrency());
            long current = rd.getBalance();
            long yesterdayBalance = rd.getYesterdayBalance();
            this.logger.info("\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\uff1a" + current);
            this.logger.info("\u8fd4\u56de\u7684\u6628\u65e5\u4f59\u989d\u4e3a\uff1a" + yesterdayBalance);
            BigDecimal totalFee = new BigDecimal(current);
            BigDecimal last = new BigDecimal(yesterdayBalance);
            info.setCurrentBalance(BigDecimalHelper.div((BigDecimal)totalFee, (BigDecimal)new BigDecimal("100.00")));
            info.setAvailableBalance(BigDecimalHelper.div((BigDecimal)totalFee, (BigDecimal)new BigDecimal("100.00")));
            info.setBalanceDateTime(LocalDateTime.now());
            info.setBankAcnt(rqst.getAcnt());
            info.setLastDayAvlBalance(BigDecimalHelper.div((BigDecimal)last, (BigDecimal)new BigDecimal("100.00")));
            ArrayList<BalanceInfo> result = new ArrayList<BalanceInfo>(16);
            result.add(info);
            return new EBBankBalanceResponse(result);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 \u3002\u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"BalanceParser_3", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]), response.getReturnMsg(), response.getReturnCode(), response.getReturnMsg()));
    }
}

