/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.ecny.service.payment.salary;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterprisePayDcpayrollcreditRequestV1;
import com.icbc.api.response.MybankEnterprisePayDcpayrollcreditResponseV1;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.ecny.service.payment.salary.PayPacker;
import kd.ebg.aqap.banks.icbc.ecny.service.payment.salary.PayParser;
import kd.ebg.aqap.banks.icbc.ecny.service.payment.salary.QueryPayImpl;
import kd.ebg.aqap.banks.icbc.ecny.service.util.GetStore;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import net.sf.json.JSONObject;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "DCPAYROLLCREDIT";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]);
    }

    public EBBankPayResponse pay(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "mybank/enterprise/pay/dcpayrollcredit/V1";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterprisePayDcpayrollcreditRequestV1.MybankEnterprisePayDcpayrollcreditRequestBizV1 bizContent = PayPacker.packer(paymentInfos);
            MybankEnterprisePayDcpayrollcreditRequestV1 request = new MybankEnterprisePayDcpayrollcreditRequestV1();
            request.setServiceUrl(BASE_URL + URI);
            request.setBizContent((BizContent)bizContent);
            this.logger.info("\u4ed8\u6b3e\u63d0\u4ea4\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)request).toString());
            try {
                MybankEnterprisePayDcpayrollcreditResponseV1 response = (MybankEnterprisePayDcpayrollcreditResponseV1)client.execute((IcbcRequest)request);
                this.logger.info("\u4ed8\u6b3e\u63d0\u4ea4\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                PayParser.parse(paymentInfos, response);
            }
            catch (Throwable t) {
                this.logger.error(t.getMessage());
                EBContext.getContext().setThrowableAfterSend(t);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

