/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balance.atomic;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.business.balance.atomic.IBalanceTransfer;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.bank.impl.AbstractBankXmlImpl;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.sdk.annotation.SdkDeprecated;

public abstract class AbstractBalanceImpl
extends AbstractBankXmlImpl
implements IBalanceTransfer,
IBankService<BankBalanceRequest, EBBankBalanceResponse, BankBalanceRequest> {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractBalanceImpl.class);

    boolean async() {
        return false;
    }

    @SdkDeprecated
    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        EBBankBalanceResponse response;
        if (this.isSupportPage(request)) {
            this.doBizWithPagePre(request);
            response = this.doBizWithPage(request);
        } else {
            response = this.process(request);
        }
        return response;
    }

    public EBBankBalanceResponse doBizWithPage(BankBalanceRequest request) {
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(16);
        try {
            do {
                EBBankBalanceResponse response;
                if (!CollectionUtil.isNotEmpty((response = this.process(request)).getBalances())) continue;
                balances.addAll(response.getBalances());
            } while (!this.isLastPage());
            return new EBBankBalanceResponse(balances);
        }
        catch (EBServiceException ex) {
            EBContext.getContext().setExceptionMsg((Exception)((Object)ex));
            throw ex;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public void doBizWithPagePre(BankBalanceRequest request) {
        this.setCurrentPage("0");
        this.setLastPage(false);
    }

    /*
     * Exception decompiling
     */
    public EBBankBalanceResponse process(BankBalanceRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean match(BankBalanceRequest request) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isSupportPage(BankBalanceRequest request) {
        return false;
    }

    public void setCurrentBalance(BalanceInfo balanceInfo, String value) {
        BalanceUtil.setBalance(balanceInfo, value, BalanceUtils.currentBalanceVerification);
    }

    public void setCurrentBalance(BalanceInfo balanceInfo, String value, int decimal) {
        BalanceUtil.setBalance(balanceInfo, value, BalanceUtils.currentBalanceVerification, decimal);
    }

    public void setAvailableBalance(BalanceInfo balanceInfo, String value) {
        BalanceUtil.setAvailableBalance(balanceInfo, value);
    }

    public void setAvailableBalance(BalanceInfo balanceInfo, String value, int decimal) {
        balanceInfo.setAvailableBalance(BalanceUtil.scale(value, decimal));
    }

    public void setLastDayAvlBalance(BalanceInfo balanceInfo, String value) {
        BalanceUtil.setLastDayAvlBalance(balanceInfo, value);
    }

    public void setLastDayAvlBalance(BalanceInfo balanceInfo, String value, int decimal) {
        balanceInfo.setLastDayAvlBalance(BalanceUtil.scale(value, decimal));
    }

    public void setFreezeBalance(BalanceInfo balanceInfo, String value) {
        BalanceUtil.setFreezeBalance(balanceInfo, value);
    }

    public void setFreezeBalance(BalanceInfo balanceInfo, String value, int decimal) {
        balanceInfo.setFreezeBalance(BalanceUtil.scale(value, decimal));
    }

    public void setDepositBalance(BalanceInfo balanceInfo, String value) {
        BalanceUtil.setDepositBalance(balanceInfo, value);
    }

    public void setDepositBalance(BalanceInfo balanceInfo, String value, int decimal) {
        balanceInfo.setDepositBalance(BalanceUtil.scale(value, decimal));
    }

    public void setBankCurrency(BalanceInfo balanceInfo, String value) {
        BalanceUtil.setBankCurrency(balanceInfo, value);
    }

    public void setBankCurrency(BalanceInfo balanceInfo, String reqBankCurrency, String resBankCurrency) {
        BalanceUtil.setBankCurrency(balanceInfo, reqBankCurrency, resBankCurrency);
    }

    public void setBankAcnt(BalanceInfo balanceInfo, List<BankAcnt> bankAccounts, String resAccount) {
        BalanceUtil.setBankAcnt(balanceInfo, bankAccounts, resAccount);
    }

    public void setBankAcnt(BalanceInfo balanceInfo, BankAcnt bankAcnt) {
        BalanceUtil.setBankAcnt(balanceInfo, bankAcnt);
    }

    public void setBalanceDateTime(BalanceInfo balanceInfo, String resDateTimeStr, DateTimeFormatter formatter) {
        BalanceUtil.setBalanceDateTime(balanceInfo, resDateTimeStr, formatter);
    }

    public void setBalanceDateTime(BalanceInfo balanceInfo, LocalDateTime balanceDateTime) {
        BalanceUtil.setBalanceDateTime(balanceInfo, balanceDateTime);
    }

    public void setBalanceDate(BalanceInfo balanceInfo, LocalDate balanceDate) {
        BalanceUtil.setBalanceDate(balanceInfo, balanceDate);
    }

    public void setBalanceDate(BalanceInfo balanceInfo, String resDateTimeStr, DateTimeFormatter formatter) {
        BalanceUtil.setBalanceDate(balanceInfo, resDateTimeStr, formatter);
    }

    public void setBalance(BalanceInfo balanceInfo, String value, BalanceUtils.Verification verification) {
        BalanceUtil.setBalance(balanceInfo, value, verification);
    }
}

