/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.credit.openCredit.util;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.credit.openCredit.Task.BankOpenCreditTask;
import kd.ebg.aqap.business.credit.openCredit.atomic.IOpencreditPretreat;
import kd.ebg.aqap.business.credit.openCredit.bank.BankOpenCreditDetailRequest;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.OpenCreditService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.codeless.CodeLessRoute;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;
import net.sf.json.JSONObject;

public class OpenCreditUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(OpenCreditUtil.class);

    public static void preTreatment(List<OpenCreditDetail> openCreditDetails) {
        for (OpenCreditDetail info : openCreditDetails) {
            OpenCreditUtil.preTreatmentEach(info);
            logger.info("\u5f53\u524d\u8bb0\u5f55\u7684\u4ed8\u6b3e\u8def\u7531\u4fe1\u606f\u4e3a:" + info.getPackageKey());
        }
    }

    public static void preTreatmentCodeless(List<OpenCreditDetail> openCreditDetails, CodeLessRoute codeLessRoute) {
        StringBuilder packageKey = new StringBuilder();
        packageKey.append("subBizType=").append(openCreditDetails.get(0).getSubBizType()).append(";");
        boolean isCodeless = false;
        if (codeLessRoute.getRouteBodies() == null || codeLessRoute.getRouteBodiesQuery() == null) {
            isCodeless = true;
        }
        for (OpenCreditDetail info : openCreditDetails) {
            info.setPackageKey(packageKey.toString());
            if (isCodeless) {
                logger.info("\u65e0\u4ee3\u7801\u8def\u7531\u7ed3\u6784\u5f02\u5e38\uff0c\u4f7f\u7528\u6709\u4ee3\u7801\u6a21\u5f0f:" + info.getPackageKey());
                OpenCreditUtil.preTreatmentEach(info);
                continue;
            }
            info.setImplClassName("codelessRoute=" + codeLessRoute.getNumber());
            info.setQueryImplClassName("codelessRoute=" + codeLessRoute.getNumber());
        }
    }

    private static void preTreatmentEach(OpenCreditDetail info) {
        StringBuilder packageKey = new StringBuilder();
        packageKey.append("acceptorAccNo=").append(info.getAccno()).append(";").append("detail_seq_id=").append(info.getDetailSeqID()).append(";").append("bizType=").append(info.getBizType()).append(";").append("subBizType=").append(info.getSubBizType()).append(";");
        info.setPackageKey(packageKey.toString());
        String bankVersionID = info.getBankVersionID();
        IOpencreditPretreat pretreat = (IOpencreditPretreat)BankBundleManager.getInstance().getImpl(bankVersionID, IOpencreditPretreat.class, (Object)info);
        if (pretreat == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u63d2\u4ef6\u5b9e\u73b0\u9519\u8befIOpencreditPretreat", (String)"OpenCreditUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        pretreat.appendData(info);
        info.setStatus(Integer.valueOf(PaymentState.INITIAL.getId()));
        info.setStatusName(PaymentState.INITIAL.getEnName());
        info.setStatusMsg(PaymentState.INITIAL.getCnName());
    }

    public static void insertPay(List<OpenCreditDetail> openCreditDetails) {
        LocalDateTime insertTime = LocalDateTime.now();
        openCreditDetails.forEach(info -> {
            info.setInsertTime(insertTime);
            info.setEbgID(((SingleNodeIDGetter)SpringContextUtil.getBean(SingleNodeIDGetter.class)).nodeID());
        });
        OpenCreditService.getInstance().save(openCreditDetails, true);
    }

    public static void async(Set<List<OpenCreditDetail>> set, EBRequest request, BankAcnt acnt) {
        String extDate = request.getHeader().getExtData();
        String loggerBankNo = "";
        try {
            if (extDate != null) {
                JSONObject object = JSONObject.fromObject((Object)extDate);
                loggerBankNo = (String)object.get("loggerBankNo");
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u65e5\u5fd7\u8ddf\u8e2a\u53f7\u5f02\u5e38\uff1a", (Object)e);
        }
        for (List<OpenCreditDetail> infos : set) {
            BankOpenCreditDetailRequest openCreditDetailRequest = OpenCreditUtil.prepareBankPayRequest(infos, acnt);
            OpenCreditDetail openCreditDetail = infos.get(0);
            for (int i = 0; i < infos.size(); ++i) {
                OpenCreditDetail info = infos.get(i);
                info.setBankSerialNo(i + 1 + "");
            }
            String bankVersion = openCreditDetail.getBankVersionID();
            String bizType = "openCredit";
            String customerId = acnt.getCustomID();
            String batchSeqId = openCreditDetail.getBatchSeqId();
            String requestSeqId = String.valueOf(request.getHeader().getRequestSeqID());
            String logRequestSeqId = String.valueOf(request.getHeader().getLogRequestSeqID());
            String logBizSeqId = String.valueOf(request.getHeader().getLogBizSeqID());
            if (StringUtils.isEmpty((String)loggerBankNo)) {
                loggerBankNo = openCreditDetail.getBankBatchSeqId();
            }
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID(requestSeqId).bizName(bizType).subBizName(bizType).bankVersionID(bankVersion).bizSeqID(batchSeqId).bankLoginID(EBContext.getContext().getBankLoginID()).logRequestSeqID(logRequestSeqId).logBizSeqID(logBizSeqId).loggerBatchNo(batchSeqId).loggerDetailNo(openCreditDetail.getBankBatchSeqId()).loggerBankNo(loggerBankNo).loggerSubType(EBContext.getContext().getLogger_sub_type()).build();
            String bankLoginId = openCreditDetailRequest.getHeader().getAcnt().getBankLoginId();
            String bankBatchSeqID = infos.get(0).getBankBatchSeqId();
            openCreditDetailRequest.setBankBatchSeqID(bankBatchSeqID);
            openCreditDetailRequest.setDetails(infos);
            openCreditDetailRequest.setTotalCount(infos.size());
            context.setBankAcnt(acnt);
            EBThreadPools.getCreditThreadPool(customerId, bankLoginId).submit((Callable)((Object)new BankOpenCreditTask(openCreditDetailRequest, context)));
        }
    }

    private static BankOpenCreditDetailRequest prepareBankPayRequest(List<OpenCreditDetail> openCreditDetails, BankAcnt acnt) {
        BankOpenCreditDetailRequest payableRequest = new BankOpenCreditDetailRequest();
        if (openCreditDetails.size() > 0) {
            OpenCreditDetail info = openCreditDetails.get(0);
            payableRequest.setDetails(openCreditDetails);
            payableRequest.setTotalCount(openCreditDetails.size());
            payableRequest.setTotalAmount(OpenCreditUtil.getTotalAmount(openCreditDetails).toString());
            payableRequest.setBankBatchSeqID(info.getBankBatchSeqId());
            payableRequest.setHeader(OpenCreditUtil.getHeader(info, acnt));
        }
        return payableRequest;
    }

    public static BigDecimal getTotalAmount(List<OpenCreditDetail> infos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        if (!Objects.isNull(infos)) {
            for (OpenCreditDetail info : infos) {
                bigDecimal = bigDecimal.add(info.getAmount());
            }
        }
        return bigDecimal;
    }

    private static BankHeader getHeader(OpenCreditDetail info, BankAcnt bankAcnt) {
        BankHeader header = new BankHeader();
        BankAcnt acnt = bankAcnt;
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        header.setCustomerID(info.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqId());
        header.setLogBizSeqID(info.getBatchSeqId());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(acnt);
        header.setClientName("ebc_bankOpenCreditTask");
        header.setClientVersion("1.0");
        return header;
    }
}

