/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.biz.IFetchDetail;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.detail.DetailInfoOnReceipt;
import kd.ebg.egf.common.utils.file.FieldUtils;

public class DetailQueryImpl
implements IFetchDetail {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailQueryImpl.class);
    private BankAcntService bankAcntService;

    public void init() {
        this.bankAcntService = (BankAcntService)SpringContextUtil.getBean(BankAcntService.class);
    }

    public List<DetailInfoOnReceipt> queryDetailFromReceipt(String bankVersion, String bankLogin, String accNo, LocalDate transDate, String bankCurrency) {
        this.init();
        ArrayList<DetailInfoOnReceipt> result = new ArrayList<DetailInfoOnReceipt>(0);
        List<DetailInfo> detailInfos = this.queryFromBank(bankVersion, bankLogin, accNo, transDate, bankCurrency);
        for (DetailInfo detailInfo : detailInfos) {
            DetailInfoOnReceipt detail = new DetailInfoOnReceipt();
            FieldUtils.fieldsCopy((Object)detailInfo, (Object)detail);
            result.add(detail);
        }
        return result;
    }

    public List<DetailInfo> queryFromBank(String bankVersion, String bankLogin, String accNo, LocalDate transDate, String bankCurrency) {
        EBBankDetailResponse response;
        String customID = EBContext.getContext().getCustomID();
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        request.setHeader(header);
        BankAcnt bankAcnt = this.bankAcntService.selectByAccNo(accNo);
        header.setAcnt(bankAcnt);
        header.setBankVersionID(bankVersion);
        header.setBankLoginID(bankLogin);
        header.setCustomerID(customID);
        header.setBankCurrency(bankCurrency);
        request.setBankCurrency(bankCurrency);
        request.setStartDate(transDate);
        request.setEndDate(transDate);
        if (transDate.equals(LocalDate.now())) {
            IDetail detail = (IDetail)BankBundleManager.getInstance().getImpl(bankVersion, IDetail.class, (Object)request);
            response = detail.detail(request);
        } else {
            IHisDetail detail = (IHisDetail)BankBundleManager.getInstance().getImpl(bankVersion, IHisDetail.class, (Object)request);
            response = detail.hisDetail(request);
        }
        return response.getDetails();
    }
}

