/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.schedule;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.aqap.business.detail.bank.DetailCompletionRequest;
import kd.ebg.aqap.business.detail.task.DetailCompensationTask;
import kd.ebg.aqap.business.detail.utils.DetailCompensation;
import kd.ebg.aqap.business.detail.utils.DetailSyncKit;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.model.DetailSyncRecord;
import kd.ebg.aqap.common.model.repository.DetailSyncRecordRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class DetailCompletionCheckAndCompensationScheduleJob
extends AbstractTask {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailCompletionCheckAndCompensationScheduleJob.class);
    private BankLoginService bankLoginService = (BankLoginService)SpringContextUtil.getBean(BankLoginService.class);
    private BankAcntService bankAcntService = (BankAcntService)SpringContextUtil.getBean(BankAcntService.class);
    private DetailSyncRecordRepository detailSyncRecordRepository = (DetailSyncRecordRepository)SpringContextUtil.getBean(DetailSyncRecordRepository.class);
    private DetailSyncKit syncKit = (DetailSyncKit)SpringContextUtil.getBean(DetailSyncKit.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        MDC.put((String)"schedule", (String)"true");
        MDC.put((String)"scheduleLog", (String)String.valueOf(SystemPropertyConfig.isScheduleLogOpen()));
        if (!BusinessPropertyConfig.isOpenDetailCompletionCheckSwitch()) {
            this.logger.info("\u5f53\u524d\u672a\u5f00\u542f\u4ea4\u6613\u660e\u7ec6\u5b8c\u6574\u6027\u68c0\u67e5\u529f\u80fd");
            return;
        }
        this.logger.info("\u4ea4\u6613\u660e\u7ec6\u5b8c\u6574\u5ea6\u68c0\u67e5\u53ca\u8865\u507f\u8c03\u5ea6\u4efb\u52a1\u5f00\u59cb");
        long start = System.currentTimeMillis();
        boolean isPaymentAllowed = SystemPropertyConfig.NOT_PAYMENT_ALLOW.getCurrentValueAsBoolean();
        if (!isPaymentAllowed) {
            this.logger.info("\u975e\u652f\u4ed8\u901a\u9053\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2");
        } else {
            String scope = BusinessPropertyConfig.getDetailCompletionCheckScope();
            if (StringUtils.isEmpty((String)scope)) {
                this.logger.info("\u4ea4\u6613\u660e\u7ec6\u5b8c\u6574\u6027\u68c0\u67e5\u65f6\u95f4\u8303\u56f4\u4e3a\u7a7a\uff0c");
                return;
            }
            String[] scopes = scope.split(",");
            Date now = new Date();
            Date startDate = null;
            Date endDate = null;
            try {
                startDate = DateUtil.preDay((Date)now, (int)(Integer.parseInt(scopes[0]) + 1));
                endDate = DateUtil.preDay((Date)now, (int)(Integer.parseInt(scopes[1]) + 1));
            }
            catch (Exception ex) {
                this.logger.info("\u4ea4\u6613\u660e\u7ec6\u5b8c\u6574\u6027\u68c0\u67e5\u65f6\u95f4\u8303\u56f4\u683c\u5f0f\u6709\u8bef{}", (Object)ex.getMessage());
            }
            this.init(startDate, endDate);
            this.logger.info("\u4ea4\u6613\u660e\u7ec6\u5b8c\u6574\u5ea6\u68c0\u67e5\u53ca\u8865\u507f\u8c03\u5ea6\u4efb\u52a1\uff0c\u68c0\u67e5\u65e5\u671f\u4e3a{}\u81f3{}", new Object[]{startDate, endDate});
        }
        long end = System.currentTimeMillis();
        this.logger.info("\u4ea4\u6613\u660e\u7ec6\u5b8c\u6574\u5ea6\u68c0\u67e5\u53ca\u8865\u507f\u8c03\u5ea6\u4efb\u52a1\u7ed3\u675f\uff0c\u8017\u65f6{}\u6beb\u79d2", (Object)(end - start));
    }

    public void init(Date startDate, Date endDate) {
        List bankLogins = this.bankLoginService.getNotDeleteByCustomId(RequestContext.get().getTenantId());
        if (CollectionUtil.isNotEmpty((Collection)bankLogins)) {
            this.logger.info("\u83b7\u53d6\u672a\u5220\u9664\u524d\u7f6e\u673a{}\u4e2a", (Object)bankLogins.size());
            List bankLoginRels = this.bankLoginService.getAllDetailBankLoginRel();
            if (CollectionUtil.isNotEmpty((Collection)bankLoginRels)) {
                this.logger.info("\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6\u4e13\u5c5e\u524d\u7f6e\u673a{}\u4e2a", (Object)bankLoginRels.size());
            }
            HashMap<String, List<DetailCompensation>> groupMap = new HashMap<String, List<DetailCompensation>>(16);
            for (BankLogin bankLogin : bankLogins) {
                String bankLoginId = bankLogin.getKey().getBankLoginId();
                List bankAcnts = this.bankAcntService.getNotDeleteAcntByBankLoginIDAndCustomID(bankLoginId, RequestContext.get().getTenantId());
                if (CollectionUtil.isEmpty((Collection)bankAcnts)) {
                    this.logger.info("\u524d\u7f6e\u673a{}\u4e0b\u8d26\u53f7\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u672c\u6b21\u5faa\u73af", (Object)bankLoginId);
                    continue;
                }
                List<DetailCompensation> detailCompensationList = this.getDetailCompensationList(bankAcnts, bankLoginId, startDate, endDate);
                if (!CollectionUtil.isNotEmpty(detailCompensationList)) continue;
                groupMap.put(bankLoginId, detailCompensationList);
            }
            this.sync(groupMap);
        } else {
            this.logger.info("\u5f53\u524d\u4e0d\u5b58\u5728\u672a\u5220\u9664\u7684\u524d\u7f6e\u673a\u5217\u8868\uff0c\u8df3\u8fc7\u672c\u6b21\u4efb\u52a1");
        }
    }

    public List<DetailCompensation> getDetailCompensationList(List<BankAcnt> bankAcnts, String bankLoginId, Date startDate, Date endDate) {
        ArrayList<DetailCompensation> compensationList = new ArrayList<DetailCompensation>(16);
        LocalDate startLocalDate = LocalDateUtil.date2LocalDate((Date)startDate);
        LocalDate endLocalDate = LocalDateUtil.date2LocalDate((Date)endDate);
        for (BankAcnt bankAcnt : bankAcnts) {
            List records = this.detailSyncRecordRepository.findByCustomIDAndAccNoAndCurrencyAndSyncDateBetween(bankAcnt.getCustomID(), bankAcnt.getAccNo(), bankAcnt.getCurrency(), startLocalDate, endLocalDate);
            LocalDate temp = LocalDateUtil.date2LocalDate((Date)startDate);
            HashSet<LocalDate> recordDate = new HashSet<LocalDate>(16);
            if (records == null || records.size() == 0) {
                this.logger.info("\u8d26\u53f7{}\u672c\u6b21\u9700\u8981\u8865\u507f\u7684\u65e5\u671f\u4e3a{}\u81f3{}", new Object[]{bankAcnt.getAccNo(), startLocalDate.toString(), endLocalDate.toString()});
                compensationList.add(new DetailCompensation(bankAcnt, startLocalDate, endLocalDate));
                continue;
            }
            ArrayList<LocalDate> localDates = new ArrayList<LocalDate>();
            for (DetailSyncRecord record : records) {
                recordDate.add(record.getSyncDate());
                if (!CosmicConstants.DETAIL_RECORD_NOT_COMPLETED.equals(record.getIsCompleted()) || record.getCompensationCount() >= CosmicConstants.DETAIL_COMPENSATION_MAX_COUNT) continue;
                localDates.add(record.getSyncDate());
            }
            while (temp.isBefore(endLocalDate) || temp.isEqual(endLocalDate)) {
                if (!recordDate.contains(temp)) {
                    localDates.add(temp);
                }
                temp = temp.plusDays(1L);
            }
            compensationList.addAll(this.syncKit.getDetailCompensations(localDates, bankAcnt));
        }
        return compensationList;
    }

    public void sync(Map<String, List<DetailCompensation>> groupMap) {
        if (!groupMap.isEmpty()) {
            this.logger.info("\u5f53\u524d\u6709{}\u4e2a\u524d\u7f6e\u673a\u5b58\u5728\u8d26\u53f7\u9700\u8865\u507f\u4ea4\u6613\u660e\u7ec6", (Object)groupMap.size());
            for (Map.Entry<String, List<DetailCompensation>> entry : groupMap.entrySet()) {
                this.submit(entry.getKey(), entry.getValue());
            }
        }
    }

    private void submit(String bankLoginID, List<DetailCompensation> detailCompensations) {
        String bizType = "detailCompensation";
        String customId = RequestContext.get().getTenantId();
        String traceId = RequestContext.get().getTraceId();
        if (StringUtils.isEmpty((String)traceId)) {
            traceId = String.valueOf(System.currentTimeMillis());
        }
        String bizSeqID = Sequence.gen18Sequence();
        this.logger.info("\u5f53\u524d\u8282\u70b9\u5904\u7406\u63d0\u4ea4\u8865\u507f\u4ea4\u6613\u660e\u7ec6traceId\u4e3a" + traceId);
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).requestSeqID("").bizName(bizType).subBizName(bizType).bankVersionID(detailCompensations.get(0).getBankAcnt().getBankVersionId()).bankLoginID(bankLoginID).bizSeqID(Sequence.gen18Sequence()).requestSeqID(Sequence.genSequence()).logBizSeqID(bizSeqID).logRequestSeqID(Sequence.gen18Sequence()).loggerBatchNo(bizSeqID).loggerDetailNo(bizSeqID).loggerBankNo(Sequence.gen18Sequence()).schedule(true).build();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo("");
        context.setBankAcnt(bankAcnt);
        EBContext.setContext((EBContext)context);
        DetailCompletionRequest request = new DetailCompletionRequest();
        request.setDetailCompensations(detailCompensations);
        BankHeader header = new BankHeader();
        header.setBizType(bizType);
        header.setSubBizType(bizType);
        header.setCustomerID(customId);
        request.setHeader(header);
        this.logger.info(String.format("\u8865\u507f\u4ea4\u6613\u660e\u7ec6\u63d0\u4ea4\u7ebf\u7a0b\u6c60\uff08%s,%s\uff09", customId, bankLoginID));
        String taskID = EBThreadPools.createScheduleBizTask(context);
        DetailCompensationTask bankDetailTask = new DetailCompensationTask(request, context);
        bankDetailTask.setTaskId(taskID);
        EBThreadPools.getDetailThreadPool(customId, bankLoginID).submit((Callable)((Object)bankDetailTask));
        this.logger.info("\u63d0\u4ea4\u8865\u507f\u4ea4\u6613\u660e\u7ec6\u7ebf\u7a0b\u6c60\u6210\u529f\uff08{},{}\uff09", new Object[]{customId, bankLoginID});
    }
}

