/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.storage.impl;

import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.business.detail.storage.sync.SyncPeriod;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.cache.CosmicCache;

@Component
public class DetailSyncPeriodCache {
    private static final String DETAIL_SYNC_RECORD = "detail.sync.record";

    public String putIfAbsent(String customID, String accNo, SyncPeriod period, String data) {
        String key = this.genKey(customID, accNo, period);
        return CosmicCache.putIfAbsent((String)("eb_detailSysncPeroid_" + key), (String)data);
    }

    public String get(String customID, String accNo, SyncPeriod period) {
        String key = this.genKey(customID, accNo, period);
        return CosmicCache.get((String)key);
    }

    private String genKey(String customID, String accNo, SyncPeriod period) {
        StringBuilder sb = new StringBuilder();
        sb.append(customID).append("-").append(accNo).append("-").append(period.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE)).append("-").append(period.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        return sb.toString();
    }
}

