/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.business.payment.cache.CacheQueryPayStorage;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.business.payment.utils.LinkPayStepHelper;
import kd.ebg.aqap.business.payment.utils.QueryPaymentUtil;
import kd.ebg.aqap.common.entity.biz.querylinkpay.QueryLinkPayDetail;
import kd.ebg.aqap.common.entity.biz.querylinkpay.QueryLinkPayRequest;
import kd.ebg.aqap.common.entity.biz.querylinkpay.QueryLinkPayRequestBody;
import kd.ebg.aqap.common.entity.biz.querylinkpay.QueryLinkPayResponse;
import kd.ebg.aqap.common.entity.biz.querylinkpay.QueryLinkPayResponseBody;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.services.LinkPaymentInfoService;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;

public class QueryLinkPayMethod
implements EBServiceMethod<QueryLinkPayRequest, QueryLinkPayResponse> {
    public QueryLinkPayResponse executeClientRequest(QueryLinkPayRequest request, EBContext context) {
        AccessUtils.checkPaymentAllowed(context);
        QueryLinkPayRequestBody body = request.getBody();
        String batchSeqId = body.getBatchSeqId();
        List infos = PaymentInfoService.getInstance().selectByBatchSeqID(batchSeqId);
        if (infos.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)"unknown_batch", (String)String.format(ResManager.loadKDString((String)"\u67e5\u65e0\u6279\u6b21\u53f7:%s\u3002", (String)"QueryLinkPayMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]), batchSeqId));
        }
        LinkPaymentInfoService linkPaymentInfoService = LinkPaymentInfoService.getInstance();
        List linkPaymentInfos = linkPaymentInfoService.selectByBatchSeqId(batchSeqId);
        if (CollectionUtils.isEmpty((Collection)linkPaymentInfos)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6839\u636e\u6279\u6b21\u6d41\u6c34\u53f7(batchSeqId)\u672a\u627e\u5230\u8054\u52a8\u652f\u4ed8\u8bb0\u5f55\u3002", (String)"QueryLinkPayMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        List<QueryLinkPayDetail> queryLinkPayDetails = LinkPayStepHelper.queryLinkPaymentDetails(linkPaymentInfos);
        String customId = request.getHeader().getCustomId();
        String key = customId + batchSeqId;
        if (!CacheQueryPayStorage.checkRepeat(key)) {
            Set<List<PaymentInfo>> paymentInfoSet = QueryLinkPayMethod.setOfLinkPay(infos);
            for (List<PaymentInfo> paymentInfoList : paymentInfoSet) {
                boolean isHasSubmitting = paymentInfoList.stream().anyMatch(info -> info.getStatus().intValue() == PaymentState.SUBMITTING.getId());
                boolean isQueryPay = paymentInfoList.stream().anyMatch(info -> info.getStatus() >= PaymentState.SUBMITED.getId() && info.getStatus() <= PaymentState.UNKNOWN.getId());
                if (isHasSubmitting) {
                    Duration duration;
                    long minutes;
                    LocalDateTime submitSuccessTime = paymentInfoList.get(0).getSubmitSuccessTime();
                    if (submitSuccessTime != null && (minutes = (duration = Duration.between(submitSuccessTime, LocalDateTime.now())).toMinutes()) > 20L) {
                        for (PaymentInfo info2 : paymentInfoList) {
                            if (info2.getStatus().intValue() != PaymentState.SUBMITTING.getId()) continue;
                            info2.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                            info2.setStatusName(PaymentState.UNKNOWN.getEnName());
                            info2.setStatusMsg(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5\uff0c\u63d0\u4ea4\u4e2d\u72b6\u6001\u6301\u7eed\u5df2\u8d85\u8fc720\u5206\u949f\u3002", (String)"QueryLinkPayMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
                            info2.setEbgID(((SingleNodeIDGetter)SpringContextUtil.getBean(SingleNodeIDGetter.class)).nodeID());
                        }
                    }
                    QueryPaymentUtil.async(QueryPaymentUtil.setOfPay(paymentInfoList), (EBRequest)request);
                    continue;
                }
                if (!isQueryPay) continue;
                QueryPaymentUtil.async(QueryPaymentUtil.setOfPay(paymentInfoList), (EBRequest)request);
            }
        }
        QueryLinkPayResponse queryLinkPayResponse = new QueryLinkPayResponse();
        QueryLinkPayResponseBody queryLinkPayResponseBody = new QueryLinkPayResponseBody();
        queryLinkPayResponseBody.setDetails(queryLinkPayDetails);
        queryLinkPayResponse.setHeader(request.getHeader());
        queryLinkPayResponse.setBody(queryLinkPayResponseBody);
        return queryLinkPayResponse;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return BizName.QueryPay.PAY_FOR_LINKPAY.name();
    }

    public static Set<List<PaymentInfo>> setOfLinkPay(List<PaymentInfo> infos) {
        HashMap map = Maps.newHashMap();
        List toQuery = infos.stream().filter(info -> info.getStatus().intValue() == PaymentState.SUBMITED.getId() || info.getStatus().intValue() == PaymentState.UNKNOWN.getId() || info.getStatus().intValue() == PaymentState.SUBMITTING.getId()).collect(Collectors.toList());
        for (PaymentInfo info2 : toQuery) {
            String detailSeqID = info2.getDetailSeqID();
            if (map.containsKey(detailSeqID)) {
                ((List)map.get(detailSeqID)).add(info2);
                continue;
            }
            map.put(detailSeqID, Lists.newArrayList());
            ((List)map.get(detailSeqID)).add(info2);
        }
        return Sets.newHashSet(map.values());
    }
}

