/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.ebg.aqap.business.payment.exception.IllegalPaymentResult;
import kd.ebg.aqap.business.payment.exception.InvalidPaymentResult;
import kd.ebg.aqap.business.payment.utils.CheckUtil;
import kd.ebg.aqap.business.payment.utils.LinkPayCacheFactory;
import kd.ebg.aqap.business.payment.utils.LinkPayTempCache;
import kd.ebg.aqap.business.payment.utils.LinkPayUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayDetail;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayRequest;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayRequestBody;
import kd.ebg.aqap.common.entity.biz.pay.PayDetail;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.properties.LinkPayConfig;
import kd.ebg.aqap.common.model.LinkPaymentInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ReUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.keywords.BankKeyWordsService;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class InfoConvertUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(InfoConvertUtils.class);

    public static String getLinkPayConfig(String bankVersion) {
        if (EBContext.getContext().isUnitTest()) {
            return LinkPayConfig.COMMON_PAY.getKey();
        }
        ObjectPropertyService objectPropertyService = ObjectPropertyService.getInstance();
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setAttrKey("LINK_PAY_CONFIG");
        key.setCustomID(RequestContext.get().getTenantId());
        key.setObjectID(bankVersion);
        key.setObjectName("BANK_BUSINESS");
        String value = objectPropertyService.getPropertyValue(key);
        if (value == null) {
            value = LinkPayConfig.COMMON_PAY.getKey();
        }
        return value;
    }

    public static PaymentInfo convert4Pay(LinkPaymentInfo linkPaymentInfo, String payerAcntNo) {
        PaymentInfo paymentInfo = new PaymentInfo();
        paymentInfo.setBizType("pay");
        paymentInfo.setSubBizType("pay");
        paymentInfo.setIndividual(Boolean.valueOf("individual".equalsIgnoreCase(linkPaymentInfo.getPayeeType())));
        LinkPayTempCache linkPayTempCache = LinkPayCacheFactory.getInstance().getLinkPayTempCache();
        BankAcnt payer = linkPayTempCache.getBankAcnt(payerAcntNo);
        BankAcnt payee = new BankAcnt();
        payee.setBankAddress(linkPaymentInfo.getPayeeBankAddr());
        payee.setAccNo(linkPaymentInfo.getPayeeAccNo());
        payee.setAccName(linkPaymentInfo.getPayeeAccName());
        payee.setBankName(linkPaymentInfo.getPayeeBankName());
        payee.setCountry(linkPaymentInfo.getPayeeCountry());
        payee.setProvince(linkPaymentInfo.getPayeeProvince());
        payee.setCity(linkPaymentInfo.getPayeeCity());
        int totalCount = CheckUtil.checkInt(linkPaymentInfo.getTotalCount().toString(), "totalCount");
        BigDecimal amount = CheckUtil.checkBigDecimal(linkPaymentInfo.getAmount().toString(), "amount");
        InfoConvertUtils.convert4Common(paymentInfo, linkPaymentInfo, payer, payee, "linkPay_pay", linkPaymentInfo.getDetailSeqId(), amount, totalCount);
        return paymentInfo;
    }

    public static PaymentInfo convert4TransUp(LinkPaymentInfo linkPaymentInfo, String payerAcntNo, String payeeAcntNo, String linkPayConfig) {
        PaymentInfo paymentInfo = new PaymentInfo();
        paymentInfo.setBizType("pay");
        if (linkPayConfig.equalsIgnoreCase(LinkPayConfig.ALLOCATION_AND_PAY.getKey())) {
            paymentInfo.setSubBizType("pay_for_capital_allocation");
            paymentInfo.setUseCn(ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"InfoConvertUtils_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        } else {
            paymentInfo.setSubBizType("pay");
            paymentInfo.setUseCn(ResManager.loadKDString((String)"\u4e1a\u52a1\u652f\u4ed8", (String)"InfoConvertUtils_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        paymentInfo.setIndividual(Boolean.FALSE);
        LinkPayTempCache linkPayTempCache = LinkPayCacheFactory.getInstance().getLinkPayTempCache();
        BankAcnt payer = linkPayTempCache.getBankAcnt(payerAcntNo);
        BankAcnt payee = linkPayTempCache.getBankAcnt(payeeAcntNo);
        BigDecimal amount = CheckUtil.checkBigDecimal(linkPaymentInfo.getAmount().toString(), "amount");
        InfoConvertUtils.convert4Common(paymentInfo, linkPaymentInfo, payer, payee, "linkPay_transUp", linkPaymentInfo.getDetailSeqId(), amount, 1);
        return paymentInfo;
    }

    public static PaymentInfo convert4TransDown(LinkPaymentInfo linkPaymentInfo, String payerAcntNo, String payeeAcntNo, String linkPayConfig) {
        PaymentInfo paymentInfo = new PaymentInfo();
        paymentInfo.setBizType("pay");
        if (linkPayConfig.equalsIgnoreCase(LinkPayConfig.ALLOCATION_AND_PAY.getKey())) {
            paymentInfo.setSubBizType("pay_for_capital_allocation");
            paymentInfo.setUseCn(ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"InfoConvertUtils_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        } else {
            paymentInfo.setSubBizType("pay");
            paymentInfo.setUseCn(ResManager.loadKDString((String)"\u4e1a\u52a1\u652f\u4ed8", (String)"InfoConvertUtils_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        paymentInfo.setIndividual(Boolean.FALSE);
        LinkPayTempCache linkPayTempCache = LinkPayCacheFactory.getInstance().getLinkPayTempCache();
        BankAcnt payer = linkPayTempCache.getBankAcnt(payerAcntNo);
        BankAcnt payee = linkPayTempCache.getBankAcnt(payeeAcntNo);
        BigDecimal amount = CheckUtil.checkBigDecimal(linkPaymentInfo.getAmount().toString(), "amount");
        InfoConvertUtils.convert4Common(paymentInfo, linkPaymentInfo, payer, payee, "linkPay_transDown", linkPaymentInfo.getDetailSeqId(), amount, 1);
        return paymentInfo;
    }

    public static PaymentInfo convert4NativeLinkPay(LinkPaymentInfo linkPaymentInfo) {
        PaymentInfo paymentInfo = new PaymentInfo();
        String payerAcntNo = linkPaymentInfo.getChildAcnt1();
        paymentInfo.setBizType("pay");
        paymentInfo.setSubBizType("pay_for_linkpay");
        paymentInfo.setIndividual(Boolean.valueOf("individual".equalsIgnoreCase(linkPaymentInfo.getPayeeType())));
        LinkPayTempCache linkPayTempCache = LinkPayCacheFactory.getInstance().getLinkPayTempCache();
        BankAcnt payer = linkPayTempCache.getBankAcnt(payerAcntNo);
        if (payer == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u7684\u5b50\u8d26\u53f7[%s]\u4e0d\u5b58\u5728\u3002", (String)"InfoConvertUtils_39", (String)"ebg-aqap-business", (Object[])new Object[0]), payerAcntNo));
        }
        BankAcnt thirdAcnt = linkPayTempCache.getBankAcnt(linkPaymentInfo.getParentAcnt());
        if (thirdAcnt == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u7684\u6bcd\u8d26\u53f7[%s]\u4e0d\u5b58\u5728\u3002", (String)"InfoConvertUtils_40", (String)"ebg-aqap-business", (Object[])new Object[0]), linkPaymentInfo.getParentAcnt()));
        }
        BankAcnt payee = new BankAcnt();
        payee.setAccNo(linkPaymentInfo.getPayeeAccNo());
        payee.setBankAddress(linkPaymentInfo.getPayeeBankAddr());
        payee.setAccName(linkPaymentInfo.getPayeeAccName());
        payee.setBankName(linkPaymentInfo.getPayeeBankName());
        payee.setCountry(linkPaymentInfo.getPayeeCountry());
        payee.setProvince(linkPaymentInfo.getPayeeProvince());
        payee.setCity(linkPaymentInfo.getPayeeCity());
        payee.setCnaps(linkPaymentInfo.getPayeeCnapsCode());
        paymentInfo.setThirdAccDept(thirdAcnt.getAccDept());
        paymentInfo.setThirdAccName(thirdAcnt.getAccName());
        paymentInfo.setThirdAccNo(thirdAcnt.getAccNo());
        paymentInfo.setThirdAreaCode(thirdAcnt.getAreaCode());
        paymentInfo.setThirdBankAddress(thirdAcnt.getBankAddress());
        paymentInfo.setThirdBankName(thirdAcnt.getBankName());
        BigDecimal amount = CheckUtil.checkBigDecimal(linkPaymentInfo.getAmount().toString(), "amount");
        InfoConvertUtils.convert4Common(paymentInfo, linkPaymentInfo, payer, payee, "linkPay_native", linkPaymentInfo.getDetailSeqId(), amount, 1);
        return paymentInfo;
    }

    private static void convert4Common(PaymentInfo paymentInfo, LinkPaymentInfo linkPaymentInfo, BankAcnt payer, BankAcnt payee, String linkpayType, String detailSeqId, BigDecimal amount, int total) {
        Boolean forceManual;
        EBContext context = EBContext.getContext();
        LinkPayTempCache linkPayTempCache = LinkPayCacheFactory.getInstance().getLinkPayTempCache(context);
        String currency = linkPaymentInfo.getCurrency();
        String batchSeqID = CheckUtil.checkStringNotNull(linkPaymentInfo.getBatchSeqId(), ResManager.loadKDString((String)"'\u6279\u6b21\u6d41\u6c34'(batchSeqID)\u3002", (String)"InfoConvertUtils_6", (String)"ebg-aqap-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u652f\u4ed8\u660e\u7ec6", (String)"InfoConvertUtils_7", (String)"ebg-aqap-business", (Object[])new Object[0]), -1);
        String feeType = linkPaymentInfo.getFeeType();
        paymentInfo.setCustomID(context.getCustomID());
        paymentInfo.setRequestSeq(Sequence.genSequence());
        paymentInfo.setAccNo(payer.getAccNo());
        paymentInfo.setBankName(payer.getBankName());
        paymentInfo.setAccName(payer.getAccName());
        paymentInfo.setBankVersionID(payer.getBankVersionId());
        paymentInfo.setBankLoginID(payer.getBankLoginId());
        paymentInfo.setBankAddress(payer.getBankAddress());
        paymentInfo.setAreaCode(payer.getAreaCode());
        paymentInfo.setAccDept(payer.getAccDept());
        paymentInfo.setAccCountry(payer.getCountry());
        paymentInfo.setAccProvince(payer.getProvince());
        paymentInfo.setAccCity(payer.getCity());
        paymentInfo.setIncomeBankAddress(payee.getBankAddress());
        paymentInfo.setIncomeAccNo(payee.getAccNo());
        paymentInfo.setIncomeAccName(payee.getAccName());
        paymentInfo.setIncomeBankName(payee.getBankName());
        paymentInfo.setIncomeCountry(payee.getCountry());
        paymentInfo.setIncomeProvince(payee.getProvince());
        paymentInfo.setIncomeCity(payee.getCity());
        paymentInfo.setIncomeAccDept(payee.getAccDept());
        paymentInfo.setIncomeAreaCode(payee.getAreaCode());
        paymentInfo.setIncomeSwiftCode(payee.getSwiftCode());
        paymentInfo.setCurrency(linkPayTempCache.getBankCurrency(currency));
        paymentInfo.setPayCurrency(linkPayTempCache.getBankCurrency(currency));
        paymentInfo.setIsoCurrencyCode(currency);
        paymentInfo.setBatchSeqID(batchSeqID);
        paymentInfo.setTotalCount(Integer.valueOf(total));
        BigDecimal totalAmount = CheckUtil.checkBigDecimal(linkPaymentInfo.getTotalAmount().toString(), "totalAmount");
        paymentInfo.setTotalAmount(totalAmount);
        paymentInfo.setAmount(amount);
        paymentInfo.setFeeType(feeType);
        paymentInfo.setInsertBatchSeq(context.getRequestSeqID() + linkpayType.replace("linkPay", ""));
        paymentInfo.setId(String.valueOf(ID.genLongId()));
        String detailBizNo = CheckUtil.checkStringNotNull(linkPaymentInfo.getDetailBizNo(), ResManager.loadKDString((String)"'\u4e1a\u52a1\u53c2\u8003\u6d41\u6c34'(detailBizNo)\u3002", (String)"InfoConvertUtils_8", (String)"ebg-aqap-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u652f\u4ed8\u660e\u7ec6", (String)"InfoConvertUtils_7", (String)"ebg-aqap-business", (Object[])new Object[0]), -1);
        if (linkpayType.equalsIgnoreCase("linkPay_pay")) {
            paymentInfo.setDetailSeqID(linkPaymentInfo.getId());
        } else if (linkpayType.equalsIgnoreCase("linkPay_transUp")) {
            paymentInfo.setDetailSeqID(linkPaymentInfo.getDetailSeqId());
        } else {
            paymentInfo.setDetailSeqID(Sequence.gen18Sequence());
        }
        paymentInfo.setLinkpayDetailSeqId(detailSeqId);
        paymentInfo.setDetailBizNo(detailBizNo);
        paymentInfo.setSameBank(Boolean.valueOf(linkPayTempCache.isSameBank(paymentInfo.getBankVersionID(), paymentInfo.getBankName(), paymentInfo.getIncomeBankName())));
        paymentInfo.setSameCity(Boolean.valueOf(InfoConvertUtils.isSameCity(paymentInfo)));
        paymentInfo.setUrgent(Boolean.valueOf(paymentInfo.is2Urgent()));
        if ("linkPay_pay".equalsIgnoreCase(linkpayType)) {
            if (paymentInfo.getIncomeCnaps() == null) {
                paymentInfo.setIncomeCnaps(linkPaymentInfo.getPayeeCnapsCode());
            }
            if (!paymentInfo.is2SameBank()) {
                payee.setCnaps(linkPaymentInfo.getPayeeCnapsCode());
                if (StringUtils.isEmpty((String)linkPaymentInfo.getPayeeCnapsCode())) {
                    logger.info("\u8de8\u884c\u5bf9\u5916\u652f\u4ed8\uff0c\u8054\u884c\u53f7\u4e3a\u7a7a");
                }
            }
        } else {
            paymentInfo.setIncomeCnaps(payee.getCnaps());
        }
        if ((forceManual = linkPaymentInfo.getForceManual()) == null) {
            forceManual = Boolean.FALSE;
        }
        paymentInfo.setForce(forceManual);
        if (StringUtils.isEmpty((String)paymentInfo.getUseCn())) {
            paymentInfo.setUseCn(CheckUtil.checkStringNotNull(linkPaymentInfo.getUseMsg(), ResManager.loadKDString((String)"\u7528\u9014\u63cf\u8ff0", (String)"InfoConvertUtils_9", (String)"ebg-aqap-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u652f\u4ed8\u660e\u7ec6", (String)"InfoConvertUtils_7", (String)"ebg-aqap-business", (Object[])new Object[0]), -1));
        }
        String useCode = CheckUtil.checkStringNotNull(linkPaymentInfo.getUseCode(), ResManager.loadKDString((String)"\u7528\u9014\u7f16\u53f7", (String)"InfoConvertUtils_10", (String)"ebg-aqap-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u652f\u4ed8\u660e\u7ec6", (String)"InfoConvertUtils_7", (String)"ebg-aqap-business", (Object[])new Object[0]), -1);
        paymentInfo.setUseCode(useCode);
        if (BusinessPropertyConfig.isPaymentIsSameInTimeLimited()) {
            paymentInfo.setExplanation(CheckUtil.checkStringNotNull(linkPaymentInfo.getDescMsg(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u6458\u8981(descMsg)", (String)"InfoConvertUtils_11", (String)"ebg-aqap-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u652f\u4ed8\u660e\u7ec6", (String)"InfoConvertUtils_7", (String)"ebg-aqap-business", (Object[])new Object[0]), -1));
        } else {
            paymentInfo.setExplanation(CheckUtil.formatStringMaybeNull(linkPaymentInfo.getDescMsg()));
        }
        paymentInfo.setAbstractMsg(linkPaymentInfo.getAbstractMsg());
        String verifyField = linkPaymentInfo.getVerifyField();
        paymentInfo.setBookingTime(linkPaymentInfo.getBookingDate());
        paymentInfo.setVerifyField(verifyField);
        paymentInfo.setReversed1(linkPaymentInfo.getReserved1());
        paymentInfo.setReversed2(linkPaymentInfo.getReserved2());
        paymentInfo.setReversed3(linkPaymentInfo.getReserved3());
        paymentInfo.setReversed4(linkPaymentInfo.getReserved4());
        paymentInfo.setLinkpayType(linkpayType);
    }

    public static boolean isSameBank(String payerBankVersionId, String payerBankName, String incomeBankName) {
        if (payerBankName.equalsIgnoreCase(incomeBankName) || incomeBankName.contains(payerBankName)) {
            return true;
        }
        List keyWords = BankKeyWordsService.getInstance().getKeyWords(payerBankVersionId);
        for (String keyWord : keyWords) {
            if (!incomeBankName.contains(keyWord) && !keyWord.contains(incomeBankName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameCity(PaymentInfo info) {
        String payAddr = info.getBankAddress();
        String incomeAddr = info.getIncomeBankAddress();
        if (StringUtils.isEmpty((String)payAddr)) {
            return false;
        }
        if (StringUtils.isEmpty((String)incomeAddr)) {
            return false;
        }
        if (payAddr.length() > 2) {
            payAddr = payAddr.replace(ResManager.loadKDString((String)"\u5e02", (String)"InfoConvertUtils_12", (String)"ebg-aqap-business", (Object[])new Object[0]), "").replace(ResManager.loadKDString((String)"\u53bf", (String)"InfoConvertUtils_13", (String)"ebg-aqap-business", (Object[])new Object[0]), "");
        }
        if (incomeAddr.length() > 2) {
            incomeAddr = incomeAddr.replace(ResManager.loadKDString((String)"\u5e02", (String)"InfoConvertUtils_12", (String)"ebg-aqap-business", (Object[])new Object[0]), "").replace(ResManager.loadKDString((String)"\u53bf", (String)"InfoConvertUtils_13", (String)"ebg-aqap-business", (Object[])new Object[0]), "");
        }
        return payAddr.contains(incomeAddr) || incomeAddr.contains(payAddr);
    }

    public static List<LinkPaymentInfo> convertLinkPayRequest(LinkPayRequest linkPayRequest) {
        JSONObject jsonObject;
        logger.info("\u4ed8\u6b3e\u8bf7\u6c42\u8f6c\u6362\u4e3a\u4ed8\u6b3e\u5bf9\u8c61");
        EBContext context = EBContext.getContext();
        EBHeader header = linkPayRequest.getHeader();
        String bizType = header.getBizType();
        String subBizType = header.getSubBizType();
        String currency = header.getCurrency();
        LinkPayRequestBody body = linkPayRequest.getBody();
        if (body == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"LinkPayRequestBody\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InfoConvertUtils_14", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        List details = body.getDetails();
        int totalCount = CheckUtil.checkInt(body.getTotalCount(), ResManager.loadKDString((String)"\u6279\u91cf\u6570(totalCount)", (String)"InfoConvertUtils_15", (String)"ebg-aqap-business", (Object[])new Object[0]));
        if (totalCount != details.size()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6279\u91cf\u6570(totalCount)\u4e0e\u5b9e\u9645\u8be6\u7ec6\u4ed8\u6b3e\u4fe1\u606f(details)\u5bf9\u8c61\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", (String)"InfoConvertUtils_16", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        LinkPaymentInfo linkPaymentInfo = new LinkPaymentInfo();
        linkPaymentInfo.setBizType(bizType);
        linkPaymentInfo.setSubBizType(subBizType);
        linkPaymentInfo.setCurrency(currency);
        linkPaymentInfo.setCustomId(context.getCustomID());
        linkPaymentInfo.setBatchSeqId(body.getBatchSeqID());
        linkPaymentInfo.setInsertBatchSeq(context.getRequestSeqID());
        linkPaymentInfo.setParentAcnt(CheckUtil.checkStringNotNull(body.getParentAcnt(), ResManager.loadKDString((String)"\u6bcd\u8d26\u53f7(parentAcnt)", (String)"InfoConvertUtils_17", (String)"ebg-aqap-business", (Object[])new Object[0]), "body", -1));
        linkPaymentInfo.setChildAcnt1(CheckUtil.checkStringNotNull(body.getChildAcnt1(), ResManager.loadKDString((String)"\u5b50\u8d26\u53f71(childAcnt1)", (String)"InfoConvertUtils_18", (String)"ebg-aqap-business", (Object[])new Object[0]), "body", -1));
        boolean idempotency = false;
        if (StringUtils.isNotEmpty((String)linkPayRequest.getExtData())) {
            jsonObject = JSONObject.parseObject((String)linkPayRequest.getExtData());
            if (jsonObject.containsKey((Object)"idempotency")) {
                idempotency = jsonObject.getBoolean("idempotency");
            }
        } else if (StringUtils.isNotEmpty((String)linkPayRequest.getBody().getExtData()) && (jsonObject = JSONObject.parseObject((String)linkPayRequest.getBody().getExtData())).containsKey((Object)"idempotency")) {
            idempotency = jsonObject.getBoolean("idempotency");
        }
        linkPaymentInfo.setIdempotency(idempotency);
        if (StringUtils.isNotEmpty((String)body.getChildAcnt2()) || StringUtils.isNotEmpty((String)body.getChildAcnt3()) || StringUtils.isNotEmpty((String)body.getChildAcnt4()) || StringUtils.isNotEmpty((String)body.getChildAcnt5())) {
            logger.info("\u8054\u52a8\u652f\u4ed8\u4e0d\u652f\u6301\u591a\u7ea7\u5b50\u8d26\u6237\uff0c\u5f53\u524d\u591a\u7ea7\u5b50\u8d26\u6237\u4e3a\uff1aChildAcnt2\uff1a" + body.getChildAcnt2() + "ChildAcnt3\uff1a" + body.getChildAcnt3() + "ChildAcnt4\uff1a" + body.getChildAcnt4() + "ChildAcnt5\uff1a" + body.getChildAcnt5());
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u4e1a\u52a1\u76ee\u524d\u4e0d\u652f\u6301\u591a\u7ea7\u5b50\u8d26\u6237\u8054\u52a8\u4e1a\u52a1\uff0c\u53ea\u652f\u6301\u4e00\u7ea7\u5b50\u8d26\u6237\u8054\u52a8\u4e1a\u52a1\u3002", (String)"InfoConvertUtils_19", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        Preconditions.checkArgument((boolean)CheckUtil.isNotContainSpace(body.getParentAcnt()), (Object)ResManager.loadKDString((String)"\u6bcd\u8d26\u53f7(parentAcnt)\u5305\u542b\u7a7a\u683c,\u8bf7\u68c0\u67e5", (String)"InfoConvertUtils_20", (String)"ebg-aqap-business", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)CheckUtil.isNotContainSpace(body.getChildAcnt1()), (Object)ResManager.loadKDString((String)"\u5b50\u8d26\u53f71(childAcnt1)\u5305\u542b\u7a7a\u683c,\u8bf7\u68c0\u67e5", (String)"InfoConvertUtils_21", (String)"ebg-aqap-business", (Object[])new Object[0]));
        linkPaymentInfo.setFeeType(CheckUtil.checkStringNotNull(body.getFeeType(), ResManager.loadKDString((String)"\u4ed8\u8d39\u7c7b\u578b(feeType)", (String)"InfoConvertUtils_22", (String)"ebg-aqap-business", (Object[])new Object[0]), "body", -1));
        BigDecimal totalAmount = CheckUtil.checkBigDecimal(body.getTotalAmount(), ResManager.loadKDString((String)"\u603b\u91d1\u989d(totalAmount)", (String)"InfoConvertUtils_23", (String)"ebg-aqap-business", (Object[])new Object[0]));
        linkPaymentInfo.setTotalAmount(totalAmount);
        linkPaymentInfo.setTotalCount(Integer.valueOf(totalCount));
        linkPaymentInfo.setBatchBizNo(body.getBatchBizNo());
        if (CollectionUtil.isEmpty((Collection)details)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8be6\u7ec6\u652f\u4ed8\u4fe1\u606fdetails\u4e3a\u7a7a", (String)"InfoConvertUtils_24", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        ArrayList<LinkPaymentInfo> linkPaymentInfos = new ArrayList<LinkPaymentInfo>(details.size());
        BigDecimal totalAmountByCalculate = new BigDecimal("0");
        for (LinkPayDetail linkPayDetail : details) {
            LinkPaymentInfo detailLinkPaymentInfo = new LinkPaymentInfo();
            FieldUtils.fieldsCopy((Object)linkPaymentInfo, (Object)detailLinkPaymentInfo);
            detailLinkPaymentInfo.setDetailSeqId(linkPayDetail.getDetailSeqID());
            detailLinkPaymentInfo.setDetailBizNo(linkPayDetail.getDetailBizNo());
            detailLinkPaymentInfo.setPayeeBankAddr(linkPayDetail.getIncomeBankAddress());
            detailLinkPaymentInfo.setPayeeAccNo(linkPayDetail.getIncomeAccNo());
            detailLinkPaymentInfo.setPayeeAccName(linkPayDetail.getIncomeAccName());
            detailLinkPaymentInfo.setPayeeBankName(linkPayDetail.getIncomeBankName());
            detailLinkPaymentInfo.setPayeeCountry(linkPayDetail.getIncomeCountry());
            detailLinkPaymentInfo.setPayeeProvince(linkPayDetail.getIncomeProvince());
            detailLinkPaymentInfo.setPayeeCity(linkPayDetail.getIncomeCity());
            detailLinkPaymentInfo.setPayeeType(linkPayDetail.getIncomeType());
            BigDecimal amount = linkPayDetail.getAmount() == null ? new BigDecimal("0") : new BigDecimal(linkPayDetail.getAmount()).setScale(2, 1);
            totalAmountByCalculate = totalAmountByCalculate.add(amount);
            detailLinkPaymentInfo.setAmount(amount);
            detailLinkPaymentInfo.setUrgent(Boolean.valueOf(linkPayDetail.isUrgent()));
            detailLinkPaymentInfo.setPayeeCnapsCode(linkPayDetail.getIncomeCnapsCode());
            detailLinkPaymentInfo.setForceManual(Boolean.valueOf(linkPayDetail.isForce()));
            detailLinkPaymentInfo.setUseCode(linkPayDetail.getUseCode());
            detailLinkPaymentInfo.setUseMsg(linkPayDetail.getUseCN());
            detailLinkPaymentInfo.setDescMsg(linkPayDetail.getExplanation());
            detailLinkPaymentInfo.setAbstractMsg(linkPayDetail.getAbstractMsg());
            detailLinkPaymentInfo.setPayeeAreaCode(linkPayDetail.getIncomeAreaCode());
            detailLinkPaymentInfo.setPayeeSwiftCode(linkPayDetail.getIncomeSwiftCode());
            detailLinkPaymentInfo.setMobile(linkPayDetail.getMobile());
            detailLinkPaymentInfo.setEmail(linkPayDetail.getEmail());
            detailLinkPaymentInfo.setVerifyField(linkPayDetail.getVerifyField());
            detailLinkPaymentInfo.setReserved1(linkPayDetail.getReserved1());
            detailLinkPaymentInfo.setReserved2(linkPayDetail.getReserved2());
            detailLinkPaymentInfo.setReserved3(linkPayDetail.getReserved3());
            if (StringUtils.isEmpty((String)linkPayDetail.getBookingTime())) {
                detailLinkPaymentInfo.setBookingDate(LocalDateTime.now());
            } else {
                String time = linkPayDetail.getBookingTime();
                if (linkPayDetail.getBookingTime().length() == 8) {
                    time = time + "000000";
                }
                detailLinkPaymentInfo.setBookingDate(LocalDateTime.parse(time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
            String[] reserveds = linkPayDetail.getReserveds();
            if (reserveds != null) {
                if (reserveds.length >= 1) {
                    detailLinkPaymentInfo.setReserved4(reserveds[0]);
                }
                if (reserveds.length >= 2) {
                    detailLinkPaymentInfo.setReserved5(reserveds[1]);
                }
                if (reserveds.length > 2) {
                    for (int j = 2; j < reserveds.length; ++j) {
                        logger.info(reserveds[j]);
                    }
                }
            }
            detailLinkPaymentInfo.setEbStatus(EbStatus.EB_PROCESSING.getName());
            detailLinkPaymentInfo.setEbStatusMsg(LinkPayUtils.LINKPAY_STATUS_ACCEPTED);
            linkPaymentInfos.add(detailLinkPaymentInfo);
        }
        if (totalAmount.compareTo(totalAmountByCalculate) != 0) {
            logger.info("\u603b\u91d1\u989d:{}\u4e0e\u6bcf\u7b14\u91d1\u989d\u4e4b\u548c:{}\u4e0d\u76f8\u7b49", new Object[]{totalAmount, totalAmountByCalculate});
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6821\u9a8c\u5f02\u5e38:\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e\u6bcf\u7b14\u91d1\u989d\u4e4b\u548c\u3002", (String)"InfoConvertUtils_36", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        logger.info("\u8f6c\u6362\u6821\u9a8c\u5b8c\u6210");
        return linkPaymentInfos;
    }

    public static void checkInvalidPayments(List<LinkPaymentInfo> linkPaymentInfos, InvalidPaymentResult paymentResult) {
        IllegalPaymentResult illegalPaymentResult = new IllegalPaymentResult();
        for (LinkPaymentInfo linkPaymentInfo : linkPaymentInfos) {
            try {
                CheckUtil.checkLength("explanation", linkPaymentInfo.getDescMsg(), 800);
                CheckUtil.checkLength("incomeAccName", linkPaymentInfo.getPayeeAccName(), 255);
                CheckUtil.checkLength("incomeBankName", linkPaymentInfo.getPayeeBankName(), 255);
                CheckUtil.checkLength("incomeBankAddress", linkPaymentInfo.getPayeeBankAddr(), 255);
                CheckUtil.checkStringNotNull(linkPaymentInfo.getDetailSeqId(), ResManager.loadKDString((String)"\u660e\u7ec6\u6d41\u6c34(detailSeqID)", (String)"InfoConvertUtils_25", (String)"ebg-aqap-business", (Object[])new Object[0]), "body", -1);
                CheckUtil.checkStringNotNull(linkPaymentInfo.getDetailBizNo(), ResManager.loadKDString((String)"\u4e1a\u52a1\u53c2\u8003\u6d41\u6c34(detailBizNo)", (String)"InfoConvertUtils_26", (String)"ebg-aqap-business", (Object[])new Object[0]), "body", -1);
                CheckUtil.formatStringMaybeNull(linkPaymentInfo.getPayeeBankAddr());
                CheckUtil.checkStringNotNull(linkPaymentInfo.getPayeeAccNo(), ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7(IncomeAccNo)", (String)"InfoConvertUtils_27", (String)"ebg-aqap-business", (Object[])new Object[0]), "body", -1);
                CheckUtil.checkStringNotNull(linkPaymentInfo.getPayeeAccName(), ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u540d\u79f0(IncomeAccName)", (String)"InfoConvertUtils_28", (String)"ebg-aqap-business", (Object[])new Object[0]), "body", -1);
                Preconditions.checkArgument((boolean)CheckUtil.isNotContainSpace(linkPaymentInfo.getPayeeAccNo()), (Object)ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\u5305\u542b\u7a7a\u683c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InfoConvertUtils_29", (String)"ebg-aqap-business", (Object[])new Object[0]));
                Preconditions.checkArgument((boolean)CheckUtil.isNotContainSpace(linkPaymentInfo.getPayeeAccName()), (Object)ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6536\u6b3e\u6237\u540d\uff0c\u4e0d\u80fd\u5305\u542b\u7a7a\u683c\u3002", (String)"InfoConvertUtils_30", (String)"ebg-aqap-business", (Object[])new Object[0]));
                CheckUtil.checkStringNotNull(linkPaymentInfo.getPayeeBankName(), ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884c(IncomeBankName)", (String)"InfoConvertUtils_31", (String)"ebg-aqap-business", (Object[])new Object[0]), "body", -1);
                CheckUtil.formatStringMaybeNull(linkPaymentInfo.getPayeeCountry());
                CheckUtil.formatStringMaybeNull(linkPaymentInfo.getPayeeProvince());
                CheckUtil.formatStringMaybeNull(linkPaymentInfo.getPayeeCity());
                CheckUtil.checkStringNotNull(linkPaymentInfo.getPayeeType(), ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b(\u516c\u53f8/\u4e2a\u4eba\u6807\u5fd7)(IncomeType)", (String)"InfoConvertUtils_32", (String)"ebg-aqap-business", (Object[])new Object[0]), "body", -1);
                CheckUtil.checkBigDecimal(String.valueOf(linkPaymentInfo.getAmount()), ResManager.loadKDString((String)"\u652f\u4ed8\u91d1\u989d(amount)", (String)"InfoConvertUtils_33", (String)"ebg-aqap-business", (Object[])new Object[0]));
                CheckUtil.checkStringNotNull(linkPaymentInfo.getUseCode(), ResManager.loadKDString((String)"\u7528\u9014\u7f16\u53f7(userCode)", (String)"InfoConvertUtils_34", (String)"ebg-aqap-business", (Object[])new Object[0]), "body", -1);
                CheckUtil.checkStringNotNull(linkPaymentInfo.getUseMsg(), ResManager.loadKDString((String)"\u7528\u9014\u63cf\u8ff0(useCN)", (String)"InfoConvertUtils_35", (String)"ebg-aqap-business", (Object[])new Object[0]), "body", -1);
                CheckUtil.formatStringMaybeNull(linkPaymentInfo.getDescMsg());
                if (StringUtils.isEmpty((String)linkPaymentInfo.getPayeeCnapsCode())) continue;
                Preconditions.checkArgument((boolean)ReUtil.isMatch((String)"^\\d{1,12}$", (String)linkPaymentInfo.getPayeeCnapsCode()), (Object)ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u8054\u884c\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e,\u53ea\u80fd\u4e3a\u4e0d\u5927\u4e8e12\u4f4d\u7684\u7eaf\u6570\u5b57\u3002", (String)"InfoConvertUtils_41", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                illegalPaymentResult.addIllegalPayment(linkPaymentInfo.getDetailSeqId(), e.getMessage());
            }
        }
        if (illegalPaymentResult.isHasIllegal() && paymentResult.isBatchRollBack()) {
            throw EBExceiptionUtil.preCheckException((String)illegalPaymentResult.toString());
        }
        paymentResult.addIllegalPaymentResult(illegalPaymentResult);
    }

    public static PayDetail converPaymentInfo2PaymentDetail(PaymentInfo paymentInfo) {
        PayDetail detail = new PayDetail();
        detail.setDetailSeqID(paymentInfo.getDetailSeqId());
        detail.setDetailBizNo(paymentInfo.getDetailBizNo());
        detail.setIncomeAccNo(paymentInfo.getIncomeAccNo());
        detail.setIncomeAccName(paymentInfo.getIncomeAccName());
        detail.setIncomeType(paymentInfo.is2Individual() ? "individual" : "company");
        detail.setIncomeBankName(paymentInfo.getIncomeBankName());
        detail.setIncomeBankAddress(paymentInfo.getIncomeBankAddress());
        detail.setIncomeCountry(paymentInfo.getIncomeCountry());
        detail.setIncomeProvince(paymentInfo.getIncomeProvince());
        detail.setIncomeCity(paymentInfo.getIncomeCity());
        detail.setIncomeAreaCode(paymentInfo.getIncomeAreaCode());
        detail.setIncomeCnapsCode(paymentInfo.getIncomeCnaps());
        detail.setIncomeSwiftCode(paymentInfo.getIncomeSwiftCode());
        detail.setAmount(paymentInfo.getAmount().toString());
        detail.setUrgent(paymentInfo.getUrgent().booleanValue());
        detail.setForce(paymentInfo.getForce().booleanValue());
        detail.setUseCN(paymentInfo.getUseCn());
        detail.setExplanation(paymentInfo.getExplanation());
        detail.setAbstractMsg(paymentInfo.getAbstractMsg());
        detail.setVerifyField("");
        detail.setEbSeqId(paymentInfo.getId());
        String state = EbStatus.convertBankState2EBG((PaymentState)PaymentState.getEnumById((int)paymentInfo.getStatus())).getName();
        detail.setEbStatus(state);
        if (StringUtils.isEmpty((String)paymentInfo.getErrorMsg()) || paymentInfo.getStatus().intValue() == PaymentState.SUCCESS.getId()) {
            detail.setEbStatusMsg(InfoConvertUtils.addTitle(ResManager.loadKDString((String)"\u94f6\u4f01\u8fd4\u56de", (String)"InfoConvertUtils_37", (String)"ebg-aqap-business", (Object[])new Object[0]), paymentInfo.getStatusMsg()));
        } else {
            detail.setEbStatusMsg(InfoConvertUtils.addTitle(ResManager.loadKDString((String)"\u94f6\u4f01\u8fd4\u56de", (String)"InfoConvertUtils_37", (String)"ebg-aqap-business", (Object[])new Object[0]), paymentInfo.getStatusMsg()) + "," + paymentInfo.getErrorMsg());
        }
        if (!StringUtils.isEmpty((String)PaymentInfoSysFiled.get(paymentInfo, PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID))) {
            detail.setBankBatchSeqId(PaymentInfoSysFiled.get(paymentInfo, PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID));
        } else {
            detail.setBankBatchSeqId(paymentInfo.getBankBatchSeqId());
        }
        detail.setBankDetailSeqId(paymentInfo.getBankDetailSeqId());
        detail.setBankStatus(paymentInfo.getBankStatus());
        detail.setBankMsg(InfoConvertUtils.addTitle(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de", (String)"InfoConvertUtils_38", (String)"ebg-aqap-business", (Object[])new Object[0]), paymentInfo.getBankMsg()));
        detail.setAmount(paymentInfo.getAmount().toString());
        return detail;
    }

    private static String addTitle(String title, String content) {
        if (StringUtils.isEmpty((String)content)) {
            return content;
        }
        return title + "," + content;
    }
}

