/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import java.util.Collection;
import java.util.List;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.MappingTable;
import kd.ebg.egf.common.repository.acnt.MappingAcctRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class ProxyUtils {
    MappingAcctRepository proxyRepository = (MappingAcctRepository)SpringContextUtil.getBean(MappingAcctRepository.class);

    public String getInquiryAccountOrDefault(String isoCurrency, BankAcnt bankAcnt, String account) {
        if (bankAcnt == null) {
            return account;
        }
        if (CollectionUtil.isEmpty((Collection)bankAcnt.getProxy())) {
            return account;
        }
        BankAcnt.Proxy proxy = bankAcnt.getProxyByCurrency(isoCurrency);
        return proxy == null ? account : proxy.getInquiryaccount();
    }

    public String getProxyPayAccountOrDefault(String isoCurrency, BankAcnt bankAcnt, String account) {
        if (bankAcnt == null) {
            return account;
        }
        if (CollectionUtil.isEmpty((Collection)bankAcnt.getProxy())) {
            return account;
        }
        BankAcnt.Proxy proxy = bankAcnt.getProxyByCurrency(isoCurrency);
        return proxy == null ? account : proxy.getPayaccount();
    }

    public String queryInquiryAccount(String parentAccount, String isoCurrency) {
        MappingTable.TableStruct child = this.queryProxy(parentAccount, isoCurrency);
        return child == null ? parentAccount : child.getAccNo();
    }

    public String queryProxyPayAccount(String parentAccount, String isoCurrency) {
        MappingTable.TableStruct child = this.queryProxy(parentAccount, isoCurrency);
        return child == null ? parentAccount : child.getReserve();
    }

    private MappingTable.TableStruct queryProxy(String parentAccount, String isoCurrency) {
        MappingTable mappingTable = this.proxyRepository.loadByAccAndCurrency(parentAccount, isoCurrency);
        List childAccts = mappingTable.getChildAccts();
        if (childAccts.isEmpty()) {
            return null;
        }
        return (MappingTable.TableStruct)childAccts.get(0);
    }
}

