/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.util;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.util.BalanceCurrencyModelUtil;
import kd.ebg.aqap.business.util.DetailCurrencyModelUtil;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class CurrencyPreCheckUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CurrencyPreCheckUtil.class);

    public static void checkBalanceCurrency(IBankService iBankService, BankAcnt acnt, String bankCurrency) {
        String bankIsoCurrency;
        String calssName = iBankService.getClass().getName();
        if (BalanceCurrencyModelUtil.isOneCurrencyModel(calssName)) {
            String bankIsoCurrency2 = CurrencyUtils.convert2Iso((String)bankCurrency);
            String acntCurrency = acnt.getCurrency();
            if (!acntCurrency.equals(bankIsoCurrency2)) {
                logger.info("\u8be5\u4f59\u989d\u63a5\u53e3\u5b9e\u73b0\u7c7b{}\u4e0d\u652f\u6301\u591a\u5e01\u79cd\u8d26\u53f7\uff0c\u68c0\u67e5\u5230\u8d26\u53f7{}\u7684\u5e01\u79cd{}\u4e0e\u4e1a\u52a1\u4e0a\u9001\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u4e2d\u65ad\u67e5\u8be2", new Object[]{calssName, acnt.getAccNo(), acntCurrency, bankIsoCurrency2});
                throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8be5\u4f59\u989d\u63a5\u53e3\u4e0d\u652f\u6301\u591a\u5e01\u79cd\u8d26\u6237", (String)"CurrencyPreCheckUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        } else if (BalanceCurrencyModelUtil.isCNYCurrencyModel(calssName) && !"CNY".equals(bankIsoCurrency = CurrencyUtils.convert2Iso((String)bankCurrency))) {
            logger.info("\u8be5\u4f59\u989d\u63a5\u53e3\u5b9e\u73b0\u7c7b{}\u4ec5\u652f\u6301\u4eba\u6c11\u5e01\u8d26\u6237\uff0c\u68c0\u67e5\u5230\u4e1a\u52a1\u4e0a\u9001\u5e01\u79cd{}\u4e0eCNY\u4e0d\u4e00\u81f4\uff0c\u4e2d\u65ad\u67e5\u8be2", new Object[]{calssName, bankIsoCurrency});
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8be5\u4f59\u989d\u63a5\u53e3\u4ec5\u652f\u6301\u4eba\u6c11\u5e01\u8d26\u6237", (String)"CurrencyPreCheckUtil_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }

    public static void checkDetailCurrency(IBankService iBankService, String acntCurrency, String bankCurrency) {
        String bankIsoCurrency;
        String calssName = iBankService.getClass().getName();
        if (DetailCurrencyModelUtil.isOneCurrencyModel(calssName)) {
            String bankIsoCurrency2 = CurrencyUtils.convert2Iso((String)bankCurrency);
            if (!acntCurrency.equals(bankIsoCurrency2)) {
                logger.info("\u8be5\u4ea4\u6613\u660e\u7ec6\u63a5\u53e3\u5b9e\u73b0\u7c7b{}\u4e0d\u652f\u6301\u591a\u5e01\u79cd\u8d26\u53f7\uff0c\u68c0\u67e5\u5230\u8d26\u53f7\u7684\u5e01\u79cd{}\u4e0e\u4e1a\u52a1\u4e0a\u9001\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u4e2d\u65ad\u67e5\u8be2", new Object[]{calssName, acntCurrency, bankIsoCurrency2});
                throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u660e\u7ec6\u63a5\u53e3\u4e0d\u652f\u6301\u591a\u5e01\u79cd\u8d26\u6237", (String)"CurrencyPreCheckUtil_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        } else if (DetailCurrencyModelUtil.isCNYCurrencyModel(calssName) && !"CNY".equals(bankIsoCurrency = CurrencyUtils.convert2Iso((String)bankCurrency))) {
            logger.info("\u8be5\u4ea4\u6613\u660e\u7ec6\u63a5\u53e3\u5b9e\u73b0\u7c7b{}\u4ec5\u652f\u6301\u4eba\u6c11\u5e01\u8d26\u6237\uff0c\u68c0\u67e5\u5230\u4e1a\u52a1\u4e0a\u9001\u5e01\u79cd{}\u4e0eCNY\u4e0d\u4e00\u81f4\uff0c\u4e2d\u65ad\u67e5\u8be2", new Object[]{calssName, bankIsoCurrency});
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u660e\u7ec6\u63a5\u53e3\u4ec5\u652f\u6301\u4eba\u6c11\u5e01\u8d26\u6237", (String)"CurrencyPreCheckUtil_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }
}

