/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ocbcsg.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.oversea.repository.OverseaDetailRepository;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public EBBankDetailResponse detail(BankDetailRequest request) {
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        EBContext context = EBContext.getContext();
        OverseaDetailRepository bean = (OverseaDetailRepository)SpringContextUtil.getBean(OverseaDetailRepository.class);
        List overseaDetails = bean.queryDetail(context.getCustomID(), startDate, endDate, request.getAcnt().getAccNo(), request.getBankCurrency());
        List<DetailInfo> detailInfos = this.parseDetail(request, overseaDetails);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> parseDetail(BankDetailRequest request, List<OverseaDetail> lists) {
        BankAcnt acnt = request.getAcnt();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        for (int i = 0; i < lists.size(); ++i) {
            OverseaDetail overseaDetail = lists.get(i);
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acnt.getAccNo());
            detail.setAccName(acnt.getAccName());
            detail.setBankName(acnt.getBankName());
            detail.setTransDate(overseaDetail.getTxDate());
            detail.setTransTime(overseaDetail.getTxDate().atTime(0, 0, 0));
            String cdFlag = overseaDetail.getCordFlag();
            BigDecimal Amount = overseaDetail.getTxAmt();
            if ("CREDIT".equalsIgnoreCase(cdFlag)) {
                detail.setCreditAmount(Amount);
                detail.setDebitAmount(BigDecimalHelper.ZERO);
            } else if ("DEBIT".equalsIgnoreCase(cdFlag)) {
                detail.setCreditAmount(BigDecimalHelper.ZERO);
                detail.setDebitAmount(Amount);
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7[%1$s],\u65e0\u6cd5\u786e\u5b9a\u8be5\u7b14\u4ea4\u6613\u7684\u501f\u8d37\u7c7b\u578b", (String)"DetailImpl_1", (String)"ebg-aqap-banks-ocbcsg-dc", (Object[])new Object[0]), cdFlag));
            }
            String txCurrency = overseaDetail.getCurrency();
            detail.setCurrency(txCurrency);
            BigDecimal balance = overseaDetail.getBalance();
            if (balance != null) {
                detail.setBalance(balance);
            }
            String oppAcntNo = overseaDetail.getBenefitAccNo();
            String oppAcntName = overseaDetail.getBenefitAccName();
            String oppBankName = overseaDetail.getBenefitBankName();
            detail.setOppAccNo(oppAcntNo);
            detail.setOppAccName(oppAcntName);
            detail.setOppBankName(oppBankName);
            String explanination = overseaDetail.getExplanation();
            detail.setExplanation(explanination);
            detailList.add(detail);
        }
        return detailList;
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        EBContext context = EBContext.getContext();
        OverseaDetailRepository bean = (OverseaDetailRepository)SpringContextUtil.getBean(OverseaDetailRepository.class);
        List overseaDetails = bean.queryDetail(context.getCustomID(), startDate, endDate, request.getAcnt().getAccNo(), request.getBankCurrency());
        List<DetailInfo> detailInfos = this.parseDetail(request, overseaDetails);
        return new EBBankDetailResponse(detailInfos);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

