/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ocbcsg.dc.services.handler;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractACKHandler;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.io.FileUtils;
import org.jdom2.Element;

public class OCBCSG_DC_PAY_ACK_Handler
extends AbstractACKHandler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(OCBCSG_DC_PAY_ACK_Handler.class);

    public List<PaymentInfo> processFile(File file) {
        List<Object> list = Lists.newArrayList();
        try {
            if (OCBCSG_DC_PAY_ACK_Handler.isFileLevelACK(file.getName())) {
                list = this.processFileLevelACK(file);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u4ed8\u6b3e\u5e94\u7b54\u62a5\u544a[%1$s]\u51fa\u9519:%2$s\u3002", (String)"OCBCSG_DC_PAY_ACK_Handler_3", (String)"ebg-aqap-banks-ocbcsg-dc", (Object[])new Object[0]), file.getName(), e.getMessage()), (Throwable)e);
        }
        return list;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return OCBCSG_DC_PAY_ACK_Handler.isFileLevelACK(fileName);
    }

    private static boolean isFileLevelACK(String fileName) {
        return fileName.contains("ACK1") || fileName.contains("ACK2") || fileName.contains("NACK2");
    }

    private List<PaymentInfo> processFileLevelACK(File file) throws Exception {
        int start;
        Element root = this.getRootFromFile(file, "UTF-8");
        String in_filename = JDomUtils.getChildText((Element)root, (String)"IN_FILENAME");
        this.logger.info(String.format("ack file content:\r\n %s", FileUtils.readFileToString((File)file, (String)"UTF-8")));
        String h2H_status = JDomUtils.getChildText((Element)root, (String)"H2H_STATUS");
        String h2H_ack_lvl = JDomUtils.getChildText((Element)root, (String)"H2H_ACK_LVL");
        List payInfoList = Lists.newArrayList();
        String batchId = null;
        if (in_filename.contains("GIROFAST")) {
            start = in_filename.lastIndexOf("GIROFAST_") + 9;
            batchId = in_filename.substring(start, start + 13);
        } else if (in_filename.contains("ALLSWIFT")) {
            start = in_filename.lastIndexOf("ALLSWIFT_") + 9;
            batchId = in_filename.substring(start, start + 13);
        }
        if ("Fail".equalsIgnoreCase(h2H_status)) {
            Element error_list = JDomUtils.getChildElement((Element)root, (String)"ERROR_LIST");
            if (StringUtils.isNotEmpty((String)batchId)) {
                payInfoList = OverseaDBHelper.getPaymentInfoByBatchId((String)batchId);
                this.logger.info(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6279\u6b21\u53f7%1$s\u67e5\u8be2\u5230%2$s\u7b14\u8bb0\u5f55\u3002", (String)"OCBCSG_DC_PAY_ACK_Handler_4", (String)"ebg-aqap-banks-ocbcsg-dc", (Object[])new Object[0]), batchId, payInfoList.size()));
                String error = "";
                if (error_list != null) {
                    error = error_list.getChildText("ERROR");
                }
                if (CollectionUtil.isNotEmpty(payInfoList)) {
                    EBGBusinessUtils.setPaymentStateWithoutBatchSizeCheck(payInfoList, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"OCBCSG_DC_PAY_ACK_Handler_1", (String)"ebg-aqap-banks-ocbcsg-dc", (Object[])new Object[0]), (String)h2H_status, (String)error);
                }
            }
        } else if ("ACK2".equalsIgnoreCase(h2H_ack_lvl) && "Success".equalsIgnoreCase(h2H_status) && StringUtils.isNotEmpty((String)batchId)) {
            payInfoList = OverseaDBHelper.getPaymentInfoByBatchId((String)batchId);
            this.logger.info(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6279\u6b21\u53f7%1$s\u67e5\u8be2\u5230%2$s\u7b14\u8bb0\u5f55\u3002", (String)"OCBCSG_DC_PAY_ACK_Handler_4", (String)"ebg-aqap-banks-ocbcsg-dc", (Object[])new Object[0]), batchId, payInfoList.size()));
            if (CollectionUtil.isNotEmpty(payInfoList)) {
                EBGBusinessUtils.setPaymentStateWithoutBatchSizeCheck(payInfoList, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"OCBCSG_DC_PAY_ACK_Handler_0", (String)"ebg-aqap-banks-ocbcsg-dc", (Object[])new Object[0]), (String)h2H_status, (String)ResManager.loadKDString((String)"ACK2\u6587\u4ef6\u6821\u9a8c\u901a\u8fc7", (String)"OCBCSG_DC_PAY_ACK_Handler_7", (String)"ebg-aqap-banks-ocbcsg-dc", (Object[])new Object[0]));
            }
        }
        return payInfoList;
    }

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }
}

