/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.services.detail;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.njb.dc.services.detail.DetailParser;
import kd.ebg.aqap.banks.njb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.njb.dc.utils.TCommon;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(TodayDetailImpl.class);

    public boolean match(BankDetailRequest request) {
        return true;
    }

    public String pack(BankDetailRequest request) {
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData("200110", "0"));
        JDomUtils.addChild((Element)ebank_root, (Element)this.getDetailRequestBody(request));
        String encoding = RequestContextUtils.getCharset();
        String rqstStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)encoding);
        return TCommon.createCommonMsg(rqstStr);
    }

    private Element getDetailRequestBody(BankDetailRequest request) throws EBServiceException {
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        ZonedDateTime zonedDateTime = request.getStartDate().atStartOfDay(ZoneId.systemDefault());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)DateTimeUtils.format((Date)Date.from(zonedDateTime.toInstant()), (String)"yyyyMMdd"));
        ZonedDateTime zonedDateTime1 = request.getEndDate().atStartOfDay(ZoneId.systemDefault());
        JDomUtils.addChild((Element)body, (String)"end_date", (String)DateTimeUtils.format((Date)Date.from(zonedDateTime1.toInstant()), (String)"yyyyMMdd"));
        return body;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        return new EBBankDetailResponse(DetailParser.getInstance().parseTodayDetail(request, responseStr));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"TodayDetailImpl_0", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]);
    }
}

