/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.services.payment.otherbank.batch;

import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.njb.dc.services.proxy.FileProxy;
import kd.ebg.aqap.banks.njb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.njb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.njb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyBatchSerialCodeQueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public String getSerialCode(BankPayRequest request) {
        CompanyBatchSerialCodeQueryImpl companyBatchSerialCodeQuery = new CompanyBatchSerialCodeQueryImpl();
        EBBankPayResponse payResponse = companyBatchSerialCodeQuery.doBiz(request);
        return payResponse.getExtData();
    }

    public int getBatchSize() {
        return 1;
    }

    public boolean match(PaymentInfo info) {
        return false;
    }

    public String pack(BankPayRequest bankPayRequest) {
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData("200112", "0"));
        Element body = new Element("body");
        PaymentInfo[] paymentInfo = bankPayRequest.getPaymentInfoAsArray();
        JDomUtils.addChild((Element)body, (String)"start_date", (String)paymentInfo[0].getRequestTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)paymentInfo[0].getRequestTime().plusSeconds(80L).format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String respStr) {
        String serialCode = "";
        Element root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(respStr), (String)RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        BankResponse bankResponse = GLBParser.parseHeader(head);
        String responseCode = bankResponse.getResponseCode();
        if ("0000".equals(responseCode)) {
            Element body = root.getChild("body");
            int record_num = Integer.parseInt(body.getChildTextTrim("record_num"));
            int field_num = Integer.parseInt(body.getChildTextTrim("field_num"));
            if (record_num == 0 || field_num == 0) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5e73\u53f0\u6d41\u6c34\u53f7\u51fa\u9519,\u94f6\u884c\u672a\u8fd4\u56de\u6d41\u6c34\u53f7\u8bb0\u5f55", (String)"CompanyBatchSerialCodeQueryImpl_0", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]));
            }
            String serial_record = "";
            if ("0".equals(head.getChildTextTrim("file_flag"))) {
                serial_record = body.getChildTextTrim("serial_record");
            } else if ("1".equals(head.getChildTextTrim("file_flag"))) {
                String file_name = body.getChildTextTrim("file_name");
                serial_record = new FileProxy().download(file_name);
            }
            String[][] serialArray = GLBParser.parseMFS(serial_record, record_num, field_num);
            String bankBatchSeqID = bankPayRequest.getBankBatchSeqID();
            for (String[] item : serialArray) {
                if (!item[1].equals(bankBatchSeqID)) continue;
                serialCode = item[0];
                break;
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5e73\u53f0\u6d41\u6c34\u53f7\u51fa\u9519\u3002", (String)"CompanyBatchSerialCodeQueryImpl_1", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]));
        }
        EBBankPayResponse ebBankPayResponse = new EBBankPayResponse();
        ebBankPayResponse.setExtData(serialCode);
        return ebBankPayResponse;
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5e73\u53f0\u6d41\u6c34\u53f7\u3002", (String)"CompanyBatchSerialCodeQueryImpl_2", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]);
    }
}

