/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.balancereconciliation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceReconciliationImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceReconciliationImpl
extends AbstractBalanceReconciliationImpl
implements IBalanceReconciliation {
    public String pack(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        BalanceReconciliationDetail detail = bankBalanceReconciliationRequest.getDetail();
        if (!StringUtils.equalsIgnoreCase((String)"Y", (String)detail.getCheckStatus())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u53cd\u9988\u4f59\u989d\u5bf9\u8d26\u7ed3\u679c\u4e3a\u4e0d\u76f8\u7b26\uff0c\u4e0d\u8bf7\u6c42\u94f6\u884c", (String)"BalanceReconciliationImpl_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        }
        String request_sn = String.valueOf(Sequence.gen16NumSequence());
        Element header = CCB_DC_Packer.createTransactionHeader("6WA006", request_sn);
        Element txInfo = new Element("TX_INFO");
        Element list = JDomUtils.addChild((Element)txInfo, (String)"LIST");
        JDomUtils.addChild((Element)list, (String)"ACCT_NO", (String)detail.getAccNo());
        JDomUtils.addChild((Element)list, (String)"BILL_NO", (String)detail.getStatementNo());
        JDomUtils.addChild((Element)txInfo, (String)"SIGN_INFO", (String)"");
        return CCB_DC_Packer.packAll2XML(header, txInfo);
    }

    public EBBankBalanceReconciliationResponse parse(BankBalanceReconciliationRequest bankBalanceReconciliationRequest, String rspStr) {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        String responseMessage = response.getResponseMessage();
        BalanceReconciliationDetail detail = bankBalanceReconciliationRequest.getDetail();
        if ("000000".equalsIgnoreCase(rspCode)) {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUCCESS, (String)rspCode, (String)ResManager.loadKDString((String)"\u5bf9\u8d26\u5b8c\u6210", (String)"BalanceReconciliationImpl_2", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        } else {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.UNKNOWN, (String)rspCode, (String)responseMessage);
        }
        return new EBBankBalanceReconciliationResponse(detail);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "6WA006";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d3b\u671f\u8d26\u6237\u5bf9\u8d26\u5355\u56de\u7b7e\u5e73\u4ea4\u6613", (String)"BalanceReconciliationImpl_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        return true;
    }
}

