/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.credit.business.open;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.business.file.AbstractAttachmentSftpImpl;
import kd.ebg.aqap.business.payment.bank.BankAttachmentRequest;
import kd.ebg.aqap.business.payment.bank.BankAttachmentResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.service.file.PayAttachmentService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FileUploadUtil
extends AbstractAttachmentSftpImpl {
    EBGLogger log = EBGLogger.getInstance().getLogger(FileUploadUtil.class);
    private PayAttachmentService payAttachmentService = (PayAttachmentService)SpringContextUtil.getBean(PayAttachmentService.class);
    private String fileId;

    public String pack(PayAttachment payAttachment) {
        String request_sn = String.valueOf(Sequence.gen16NumSequence());
        Element header = CCB_DC_Packer.createTransactionHeader("NWL902", request_sn);
        Element txInfo = new Element("TX_INFO");
        if (StringUtils.isEmpty((String)this.fileId)) {
            JDomUtils.addChild((Element)txInfo, (String)"bizID", (String)"");
        } else {
            JDomUtils.addChild((Element)txInfo, (String)"bizID", (String)this.fileId);
        }
        String filePatch = RequestContextUtils.getBankParameterValue((String)"SFTP_PATH");
        filePatch = filePatch + payAttachment.getFileName();
        JDomUtils.addChild((Element)txInfo, (String)"SEND_FILE", (String)filePatch);
        return CCB_DC_Packer.packAll2XML(header, txInfo);
    }

    public void parse(PayAttachment payAttachment, String rspStr) {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        ParserUtils.checkRspCode((BankResponse)response, (String)"000000");
        Element txInfo = root.getChild("TX_INFO");
        String bizID = ParserUtils.checkUnNullableElement((Element)txInfo, (String)"bizID");
        payAttachment.setFileID(bizID);
        this.setUploadStatus(payAttachment, AttachmentState.SUBMITED, response.getResponseCode(), response.getResponseMessage());
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "NWL902";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56fd\u7ed3\u6587\u4ef6\u4e0a\u4f20", (String)"FileUploadUtil_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    public List<PayAttachment> uploadFile(OpenCreditDetail creditDetail) {
        List payAttachments = null;
        QFilter qFilter = QFilter.of((String)"bank_batch_seq_id = ?", (Object[])new Object[]{creditDetail.getBankBatchSeqId()});
        boolean exists = QueryServiceHelper.exists((String)"aqap_pay_attachment", (QFilter[])qFilter.toArray());
        if (!exists) {
            this.log.info("\u6ca1\u6709\u6587\u4ef6\u9700\u8981\u4e0a\u4f20");
            return null;
        }
        payAttachments = this.payAttachmentService.findByBankBatchSeqId(creditDetail.getBankBatchSeqId());
        if (payAttachments == null || payAttachments.isEmpty()) {
            return null;
        }
        BankAttachmentRequest request = new BankAttachmentRequest();
        request.setPayAttachments(payAttachments);
        BankAttachmentResponse response = super.doBiz(request);
        return response.getPayAttachments();
    }
}

