/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.credit.business.open;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.banks.ccb.dc.services.credit.business.CommonUtil;
import kd.ebg.aqap.banks.ccb.dc.services.credit.business.open.FileUploadUtil;
import kd.ebg.aqap.banks.ccb.dc.services.credit.business.open.QueryOpenCreditImpl;
import kd.ebg.aqap.business.credit.EBGCreditUtils;
import kd.ebg.aqap.business.credit.openCredit.atomic.AbstractOpenCreditImpl;
import kd.ebg.aqap.business.credit.openCredit.atomic.IOpenCredit;
import kd.ebg.aqap.business.credit.openCredit.atomic.IQueryOpenCredit;
import kd.ebg.aqap.business.credit.openCredit.bank.BankOpenCreditDetailRequest;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.file.PayAttachment;
import org.jdom2.Element;

public class OpenCreditImpl
extends AbstractOpenCreditImpl
implements IOpenCredit {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(OpenCreditImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryOpenCredit> defaultQueryClass() {
        return QueryOpenCreditImpl.class;
    }

    public String pack(BankOpenCreditDetailRequest bankOpenCreditDetailRequest, String s) {
        return null;
    }

    public List<OpenCreditDetail> parse(BankOpenCreditDetailRequest request, String responseStr) {
        Element root = CCB_DC_Parser.parseString2Root(responseStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        Element txInfo = root.getChild("TX_INFO");
        String message = txInfo.getChildTextTrim("FalRs_CntDsc");
        if ("000000".equals(response.getResponseCode())) {
            EBGCreditUtils.setPaymentState((List)request.getDetails(), (PaymentState)PaymentState.SUBMITED, (String)response.getResponseCode(), (String)"");
        } else {
            EBGCreditUtils.setPaymentState((List)request.getDetails(), (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return request.getDetails();
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "NWL900";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e1a\u52a1\u63a5\u6536\u670d\u52a1-\u5f00\u8bc1", (String)"OpenCreditImpl_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(OpenCreditDetail openCreditDetail) {
        return true;
    }

    public boolean isPackerAuto() {
        return true;
    }

    public boolean isParserAuto() {
        return false;
    }

    public String getStructIdPacker() {
        return "openDetail";
    }

    public String packerUtil(BankOpenCreditDetailRequest request, String pageTag) {
        FileUploadUtil fileUploadUtil = new FileUploadUtil();
        List<PayAttachment> payAttachments = fileUploadUtil.uploadFile((OpenCreditDetail)request.getDetails().get(0));
        if (payAttachments != null) {
            for (PayAttachment attachment : payAttachments) {
                if (AttachmentState.FAIL.getId() != attachment.getStatus().intValue()) continue;
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u6d41\u7a0b\u7ec8\u6b62", (String)"OpenCreditImpl_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
            }
        }
        String dateStr = OpenCreditImpl.reloaddata(request);
        String jsonStr = super.packerUtil(request, pageTag);
        ((OpenCreditDetail)request.getDetails().get(0)).setLastShipDate(dateStr);
        JSONObject object = JSONObject.parseObject((String)jsonStr);
        if (payAttachments != null) {
            JSONArray FileList = new JSONArray();
            for (PayAttachment attachment : payAttachments) {
                JSONObject each = new JSONObject();
                each.put("FileId", (Object)attachment.getFileID());
                each.put("FileName", (Object)attachment.getFileName());
                FileList.add((Object)each);
            }
            object.put("FileList", (Object)FileList);
        } else {
            JSONArray FileList = new JSONArray();
            object.put("FileList", (Object)FileList);
        }
        return CommonUtil.packer("IL", "ISS", object.toJSONString());
    }

    public String getDateStr() {
        return "yyyy-MM-dd";
    }

    public static String reloaddata(BankOpenCreditDetailRequest request) {
        String dateStr = ((OpenCreditDetail)request.getDetails().get(0)).getLastShipDate();
        String result = OpenCreditImpl.convertDate(dateStr);
        ((OpenCreditDetail)request.getDetails().get(0)).setLastShipDate(result);
        return dateStr;
    }

    public static String convertDate(String dateStr) {
        if (dateStr == null || dateStr.isEmpty()) {
            return "";
        }
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return outputFormat.format(inputFormat.parse(dateStr));
        }
        catch (ParseException e) {
            logger.error("dateStr error:" + dateStr);
            return "";
        }
    }
}

