/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.detail;

import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.banks.ccb.dc.services.detail.DetailParser;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class DetailPage {
    public String getFirstPageTag() throws EBServiceException {
        return "1_";
    }

    public String getNextPageTag(String rspStr, String pageTag) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr = DetailParser.preTreatXML(rspStr));
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (DetailParser.isNoDetilRspCode(response.getResponseCode())) {
            return null;
        }
        int index = pageTag.indexOf("_");
        String currentPageTag = pageTag.substring(0, index);
        int nextPage = Integer.parseInt(currentPageTag) + 1;
        String poststr = "";
        if (pageTag.equalsIgnoreCase(this.getFirstPageTag())) {
            Element txInfo = root.getChild("TX_INFO");
            poststr = txInfo.getChildTextTrim("POSTSTR");
            if (StringUtils.isEmpty((String)poststr)) {
                poststr = "";
            }
        } else {
            poststr = pageTag.substring(index + 1);
        }
        return nextPage + "_" + poststr.trim();
    }

    public boolean isLastPage(String rspStr, String pageTag) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr = DetailParser.preTreatXML(rspStr));
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (DetailParser.isNoDetilRspCode(response.getResponseCode())) {
            return true;
        }
        int index = pageTag.indexOf("_");
        String currentPageTag = pageTag.substring(0, index);
        Element txInfo = root.getChild("TX_INFO");
        int totalPage = Integer.parseInt(ParserUtils.checkUnNullableElement((Element)txInfo, (String)"TOTAL_PAGE"));
        return Integer.parseInt(currentPageTag) > totalPage;
    }
}

