/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.fileUtil.FileHelper;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.fileUtil.FileHelperFactory;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.impl.AbstractBankXmlImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CCB_DCFileUtil
extends AbstractBankXmlImpl {
    private static String uploadFile = "BatchSalaryPayment";
    private static String downloadFile = "BatchSalaryQueryPayment";
    private static String fileStart = "KDfileStart";

    public String uploadFile(String fileName, String fileContent) throws EBServiceException {
        try {
            EBContext.getContext().setProcessFlag(PROXY_PROCESS_PACK);
            String rqstStr = this.packUplaodFileXML(fileName, fileContent);
            String rspStr = this.sendAndRecvMsg(rqstStr);
            EBContext.getContext().setProcessFlag(PROXY_PROCESS_PARSE);
            return this.parseUplaodFileXML(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String downloadFile(String fileName) throws EBServiceException {
        try {
            EBContext.getContext().setProcessFlag(PROXY_PROCESS_PACK);
            String rqstStr = this.packDownlaodFileXML(fileName);
            String rspStr = this.sendAndRecvMsg(rqstStr);
            EBContext.getContext().setProcessFlag(PROXY_PROCESS_PARSE);
            return this.parseDownlaodFileXML(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String packUploadFileContentStr(PaymentInfo[] paymentInfos) throws EBServiceException {
        String batchPayFileType = BankBusinessConfig.getBatchPayFileType(paymentInfos[0].getAccNo());
        FileHelper fileHelper = FileHelperFactory.createFileHelper(batchPayFileType);
        String fileContent = fileHelper.packFileContent(paymentInfos);
        if (StringUtils.isEmpty((String)fileContent)) {
            return "";
        }
        return fileStart + fileHelper.packFileContent(paymentInfos);
    }

    public String packUplaodFileXML(String fileName, String fileContent) throws EBServiceException {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = CCB_DCFileUtil.createHead(uploadFile);
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"file", (String)fileName);
        JDomUtils.addChild((Element)reqPara, (String)"fileContent", (String)fileContent);
        return JDomUtils.root2String((Element)simulator, (String)"UTF-8");
    }

    public String packDownlaodFileXML(String fileName) throws EBServiceException {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = CCB_DCFileUtil.createHead(downloadFile);
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"fileName", (String)fileName);
        return JDomUtils.root2String((Element)simulator, (String)"UTF-8");
    }

    public String parseUplaodFileXML(String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)"UTF-8");
        BankResponse rsp = CCB_DCFileUtil.parseHeader(root);
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ,%1$s %2$s", (String)"CCB_DCFileUtil_6", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"CCB_DCFileUtil_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!"SUCCESS".equalsIgnoreCase(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 ,%1$s %2$s", (String)"CCB_DCFileUtil_7", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        Element filContent = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"fileContent");
        String fileName = filContent.getTextTrim();
        return fileName;
    }

    public String parseDownlaodFileXML(String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)"UTF-8");
        BankResponse rsp = CCB_DCFileUtil.parseHeader(root);
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 ,%1$s %2$s", (String)"CCB_DCFileUtil_8", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"CCB_DCFileUtil_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!"SUCCESS".equalsIgnoreCase(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25 ,%1$s %2$s", (String)"CCB_DCFileUtil_9", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        String fileContent = JDomUtils.getChildTextTrim((Element)rspPara, (String)"fileContent");
        return fileContent;
    }

    public static Element createHead(String bizType) throws EBServiceException {
        return CCB_DCFileUtil.createHead(bizType, Sequence.genSequence());
    }

    public static Element createHead(String bizType, String seqno) throws EBServiceException {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.formatDate((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)DateTimeUtils.formatTime((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        return head;
    }

    public static BankResponse parseHeader(Element root) throws EBServiceException {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"CCB_DCFileUtil_5", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }

    /*
     * Exception decompiling
     */
    public String sendAndRecvMsg(String rqstStr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getBankInterval() {
        return 0L;
    }
}

