/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZoneOffset;
import java.util.Date;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.QueryPayPacker;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.QueryPayParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 2000;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "6W2104&6W0111";
    }

    public String getBizDesc() {
        return "6W2104&6W0111";
    }

    public String pack(BankPayRequest request) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return null;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        boolean flag;
        QueryPayParser queryPayParser = new QueryPayParser();
        QueryPayPacker queryPayPacker = new QueryPayPacker();
        String bankBatchSeqID = request.getBankBatchSeqID();
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Long submitSuccessTime = paymentInfos[0].getSubmitSuccessTime().toInstant(ZoneOffset.of("+8")).toEpochMilli();
        Long now = new Date().getTime();
        boolean bl = flag = now - submitSuccessTime >= 3600000L;
        if (!flag && paymentInfos[0].getStatus().intValue() == PaymentState.SUBMITED.getId()) {
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        try {
            ConnectionFactory factory = this.getConnectionFactory();
            String rqstStr6W2104 = queryPayPacker.packQueryPay(paymentInfos);
            String rspStr6W2104 = this.sendRsqtAndRecvRsp(factory, rqstStr6W2104, bankBatchSeqID);
            queryPayParser.parseQueryPay(paymentInfos, rspStr6W2104);
            if (paymentInfos[0].getStatus().intValue() == PaymentState.SUBMITED.getId() && "1".equalsIgnoreCase(paymentInfos[0].getBankStatus())) {
                String rqstStr6W0111 = new QueryPayPacker().packQueryPay6W0111(paymentInfos, rspStr6W2104);
                String rspStr6W0111 = this.sendRsqtAndRecvRsp(factory, rqstStr6W0111, bankBatchSeqID);
                new QueryPayParser().parseQueryPay6W0111(paymentInfos, rspStr6W0111, rspStr6W2104);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public String sendRsqtAndRecvRsp(ConnectionFactory factory, String rsqt, String bankBatchSeqID) throws Exception {
        String rsp = "";
        try {
            IConnection conn = this.getConnection(factory);
            this.openConnection(conn);
            try (OutputStream os = this.getOutputStream(conn);){
                this.send(os, rsqt);
                try (InputStream is = this.getInputStream(conn);){
                    rsp = this.recv(is);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return rsp;
    }
}

