/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.fileUtil;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.fileUtil.FileHelper;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class FileHelper4OldTemplate
implements FileHelper {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(FileHelper4OldTemplate.class);
    public static final String CCBBANKBATCHID = "ccb_bank_batch_id";
    private static final String SEPERATOR = ",";
    private static final String BANKNAME = FileHelper4OldTemplate.getBankName();

    private static String getBankName() {
        return ResManager.loadKDString((String)"\u6df1\u5733\u5efa\u884c", (String)"FileHelper4OldTemplate_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    @Override
    public String packFileContent(PaymentInfo[] paymentInfos) {
        StringBuilder sBuffer = new StringBuilder();
        for (PaymentInfo info : paymentInfos) {
            if (info.is2SameBank()) {
                sBuffer.append(info.getAccNo()).append(SEPERATOR).append(info.getAmount().toString()).append(SEPERATOR).append(info.getIncomeAccNo()).append(SEPERATOR).append(info.getIncomeAccName()).append(SEPERATOR).append(BANKNAME).append(SEPERATOR).append(info.getExplanation()).append("-").append(info.getBankDetailSeqId()).append(SEPERATOR).append("\n");
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u5efa\u884c\u5916\u8054\u7248\u4ee3\u53d1\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u8de8\u884c\u4ea4\u6613\u3002", (String)"FileHelper4OldTemplate_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)"", (String)"");
            EBGBusinessUtils.setPaymentUpdateTimeAndStatus((PaymentInfo)info, (LocalDateTime)LocalDateTime.now());
        }
        return sBuffer.toString();
    }

    @Override
    public Map parseFileContent(String fileContent) {
        String[] lines;
        log.info("ccb_dc old template file content: \n" + fileContent);
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        for (String line : lines = StringUtils.split((String)fileContent, (String)"\n")) {
            String[] rows = StringUtils.split((String)line, (String)SEPERATOR);
            String key = RequestContextUtils.getRunningParam((String)CCBBANKBATCHID);
            if (this.IsSplited(rows[5])) {
                key = rows[5].split("-")[1];
            }
            if (PropertiesConstants.getValue((String)"SUCCESS").equalsIgnoreCase(rows[6])) {
                resultMap.put(key, "SUCCESS");
                continue;
            }
            resultMap.put(key, rows[7]);
        }
        return resultMap;
    }

    @Override
    public String genKey(PaymentInfo info) {
        return info.getBankDetailSeqID();
    }

    private boolean IsSplited(String key) {
        return key.contains("-") && key.split("-").length > 1;
    }
}

